/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.olap.Cube;
import com.elixirtech.data2.olap.CubeDataSource;
import com.elixirtech.data2.olap.CubeHelper;
import com.elixirtech.data2.olap.Hierarchy;
import com.elixirtech.data2.olap.IDimension;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.jdom.Element;
import java.util.List;

public class CubeDefinition
extends DataSourceDefinition {
    private static final String COLLAPSE_ROWS = "collapse-rows";
    private static final String COLLAPSE_COLUMNS = "collapse-columns";
    private static final String KEEP_ROW_TOTALS = "keep-row-totals";
    private static final String KEEP_COLUMN_TOTALS = "keep-column-totals";
    private static final String COLUMN_TITLE = "column-title";
    private static final String ROW_TITLE = "row-title";

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("version");
        if (StringUtil.isEmpty(string) || "1".equals(string)) {
            return this.getDataSource1(dataSourceManager, element);
        }
        return this.getDataSource2(dataSourceManager, element);
    }

    public IDataSource getDataSource1(DataSourceManager dataSourceManager, Element element) throws DataException {
        Element element2;
        String string = element.getAttributeValue("name");
        DataSchema dataSchema = null;
        Element element3 = element.getChild("schema", NS_DATASOURCE);
        if (element3 != null) {
            dataSchema = CubeDefinition.loadSchema(element3);
        }
        if ((element2 = element.getChild("cube", NS_DATASOURCE)) == null) {
            throw new DataException("Can't load cube element");
        }
        IDataSource iDataSource = this.getParent(dataSourceManager, element2);
        Cube cube = new Cube(iDataSource);
        this.defineDimensions(element2, cube);
        Measure[] measureArray = this.defineMeasures(element2, cube);
        IDimension[] iDimensionArray = this.defineRows(element2, cube);
        IDimension[] iDimensionArray2 = this.defineColumns(element2, cube, iDimensionArray);
        CubeDataSource cubeDataSource = new CubeDataSource(string, cube, iDimensionArray, iDimensionArray2, measureArray);
        cubeDataSource.setDescription(element.getAttributeValue("description"));
        cubeDataSource.setCollapseRows("Yes".equals(element2.getAttributeValue(COLLAPSE_ROWS)));
        cubeDataSource.setCollapseColumns("Yes".equals(element2.getAttributeValue(COLLAPSE_COLUMNS)));
        cubeDataSource.setKeepRowTotals("Yes".equals(element2.getAttributeValue(KEEP_ROW_TOTALS)));
        cubeDataSource.setKeepColumnTotals("Yes".equals(element2.getAttributeValue(KEEP_COLUMN_TOTALS)));
        if (dataSchema != null) {
            cubeDataSource.setSchema(dataSchema);
        }
        return cubeDataSource;
    }

    private IDimension[] defineColumns(Element element, Cube cube, IDimension[] iDimensionArray) {
        List<Element> list = element.getChildren("column", NS_DATASOURCE);
        IDimension[] iDimensionArray2 = new IDimension[list.size()];
        for (int i = 0; i < iDimensionArray2.length; ++i) {
            Element element2 = list.get(i);
            String string = element2.getAttributeValue("dimension");
            if (cube.hasHierarchy(string)) {
                iDimensionArray[i] = cube.getHierarchy(string);
                continue;
            }
            iDimensionArray2[i] = cube.createDimension(string, "Ascending", "Each Value", "", null, true);
        }
        return iDimensionArray2;
    }

    private IDimension[] defineRows(Element element, Cube cube) {
        List<Element> list = element.getChildren("row", NS_DATASOURCE);
        IDimension[] iDimensionArray = new IDimension[list.size()];
        for (int i = 0; i < iDimensionArray.length; ++i) {
            Element element2 = list.get(i);
            String string = element2.getAttributeValue("dimension");
            iDimensionArray[i] = cube.hasHierarchy(string) ? cube.getHierarchy(string) : cube.createDimension(string, "Ascending", "Each Value", "", null, true);
        }
        return iDimensionArray;
    }

    private Measure[] defineMeasures(Element element, final Cube cube) throws DataException {
        final List<Element> list = element.getChildren("measure", NS_DATASOURCE);
        CubeHelper.MeasureInfoSet measureInfoSet = new CubeHelper.MeasureInfoSet(){

            @Override
            public int getCount() {
                return list.size();
            }

            @Override
            public String[] getFunctionInfo(int n) {
                Element element = (Element)list.get(n);
                return new String[]{element.getAttributeValue("name"), element.getAttributeValue("function"), element.getAttributeValue("pattern")};
            }

            @Override
            public Cube getCube() {
                return cube;
            }
        };
        return CubeHelper.buildMeasures(measureInfoSet);
    }

    private void defineDimensions(Element element, Cube cube) {
        for (Element element2 : element.getChildren("dimension", NS_DATASOURCE)) {
            Level[] levelArray;
            String string = element2.getAttributeValue("name");
            String string2 = element2.getAttributeValue("type");
            if ("Level".equals(string2)) {
                levelArray = this.loadLevel(cube, element2);
                cube.createDimension((Level)levelArray);
                continue;
            }
            levelArray = this.loadLevels(cube, element2);
            cube.createHierarchy(string, levelArray);
        }
    }

    public IDataSource getDataSource2(DataSourceManager dataSourceManager, Element element) throws DataException {
        Element element2;
        String string = element.getAttributeValue("name");
        DataSchema dataSchema = null;
        Element element3 = element.getChild("schema", NS_DATASOURCE);
        if (element3 != null) {
            dataSchema = CubeDefinition.loadSchema(element3);
        }
        if ((element2 = element.getChild("cube", NS_DATASOURCE)) == null) {
            throw new DataException("Can't load cube element");
        }
        IDataSource iDataSource = this.getParent(dataSourceManager, element2);
        Cube cube = new Cube(iDataSource);
        this.defineDimensions2(element2, cube);
        Measure[] measureArray = this.defineMeasures(element2, cube);
        IDimension[] iDimensionArray = this.defineRows2(element2, cube);
        IDimension[] iDimensionArray2 = this.defineColumns2(element2, cube);
        CubeDataSource cubeDataSource = new CubeDataSource(string, cube, iDimensionArray, iDimensionArray2, measureArray);
        cubeDataSource.setDescription(element.getAttributeValue("description"));
        cubeDataSource.setCollapseRows("Yes".equals(element2.getAttributeValue(COLLAPSE_ROWS)));
        cubeDataSource.setCollapseColumns("Yes".equals(element2.getAttributeValue(COLLAPSE_COLUMNS)));
        cubeDataSource.setKeepRowTotals("Yes".equals(element2.getAttributeValue(KEEP_ROW_TOTALS)));
        cubeDataSource.setKeepColumnTotals("Yes".equals(element2.getAttributeValue(KEEP_COLUMN_TOTALS)));
        cubeDataSource.setColumnTitle(element2.getAttributeValue(COLUMN_TITLE));
        cubeDataSource.setRowTitle(element2.getAttributeValue(ROW_TITLE));
        if (dataSchema != null) {
            cubeDataSource.setSchema(dataSchema);
        }
        return cubeDataSource;
    }

    private IDimension[] defineColumns2(Element element, Cube cube) {
        List<Element> list = element.getChildren("column", NS_DATASOURCE);
        IDimension[] iDimensionArray = new IDimension[list.size()];
        for (int i = 0; i < iDimensionArray.length; ++i) {
            Element element2 = list.get(i);
            iDimensionArray[i] = "hierarchy".equals(element2.getAttributeValue("type")) ? cube.getHierarchy(element2.getAttributeValue("name")) : cube.createDimension(this.loadLevel(cube, element2));
        }
        return iDimensionArray;
    }

    private IDimension[] defineRows2(Element element, Cube cube) {
        List<Element> list = element.getChildren("row", NS_DATASOURCE);
        IDimension[] iDimensionArray = new IDimension[list.size()];
        for (int i = 0; i < iDimensionArray.length; ++i) {
            Element element2 = list.get(i);
            iDimensionArray[i] = "hierarchy".equals(element2.getAttributeValue("type")) ? cube.getHierarchy(element2.getAttributeValue("name")) : cube.createDimension(this.loadLevel(cube, element2));
        }
        return iDimensionArray;
    }

    private void defineDimensions2(Element element, Cube cube) {
        for (Element element2 : element.getChildren("hierarchy", NS_DATASOURCE)) {
            String string = element2.getAttributeValue("name");
            Level[] levelArray = this.loadLevels(cube, element2);
            cube.createHierarchy(string, levelArray);
        }
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof CubeDataSource)) {
            throw new IllegalArgumentException("Not a CubeDataSource2");
        }
        CubeDataSource cubeDataSource = (CubeDataSource)iDataSource;
        Element element = this.defineDataSource(cubeDataSource);
        element.setAttribute("version", "2");
        Element element2 = new Element("cube", NS_DATASOURCE);
        element2.setAttribute("parent", cubeDataSource.getParent().getName());
        element2.setAttribute(COLUMN_TITLE, cubeDataSource.getColumnTitle());
        element2.setAttribute(ROW_TITLE, cubeDataSource.getRowTitle());
        DataSchema dataSchema = cubeDataSource.getCachedSchema();
        if (dataSchema != null) {
            CubeDefinition.saveSchema(dataSchema, element);
        }
        this.setDimensions(cubeDataSource, element2);
        this.setMeasures(cubeDataSource, element2);
        this.setRows(cubeDataSource, element2);
        this.setColumns(cubeDataSource, element2);
        CubeDefinition.setAttribute(element2, COLLAPSE_ROWS, cubeDataSource.isCollapseRows());
        CubeDefinition.setAttribute(element2, COLLAPSE_COLUMNS, cubeDataSource.isCollapseColumns());
        CubeDefinition.setAttribute(element2, KEEP_ROW_TOTALS, cubeDataSource.isKeepRowTotals());
        CubeDefinition.setAttribute(element2, KEEP_COLUMN_TOTALS, cubeDataSource.isKeepColumnTotals());
        element.addContent(element2);
        return element;
    }

    private void setColumns(CubeDataSource cubeDataSource, Element element) {
        IDimension[] iDimensionArray = cubeDataSource.getColumns();
        for (int i = 0; i < iDimensionArray.length; ++i) {
            Element element2 = new Element("column", NS_DATASOURCE);
            if (iDimensionArray[i] instanceof Hierarchy) {
                CubeDefinition.setAttribute(element2, "type", "hierarchy");
                CubeDefinition.setAttribute(element2, "name", iDimensionArray[i].getName());
            } else {
                CubeDefinition.setAttribute(element2, "type", "level");
                Level level = iDimensionArray[i].getLevel(0);
                CubeDefinition.setAttribute(element2, "name", level.getName());
                CubeDefinition.setAttribute(element2, "sort", level.getSortOrder());
                CubeDefinition.setAttribute(element2, "group-on", level.getGroupOn());
                CubeDefinition.setAttribute(element2, "group-data", level.getGroupData());
                CubeDefinition.setAttribute(element2, "derived-field", level.getDerivedFieldName());
                CubeDefinition.setAttribute(element2, "hide-totals", !level.isShowTotals());
            }
            element.addContent(element2);
        }
    }

    private void setRows(CubeDataSource cubeDataSource, Element element) {
        IDimension[] iDimensionArray = cubeDataSource.getRows();
        for (int i = 0; i < iDimensionArray.length; ++i) {
            Element element2 = new Element("row", NS_DATASOURCE);
            if (iDimensionArray[i] instanceof Hierarchy) {
                CubeDefinition.setAttribute(element2, "type", "hierarchy");
                CubeDefinition.setAttribute(element2, "name", iDimensionArray[i].getName());
            } else {
                CubeDefinition.setAttribute(element2, "type", "level");
                Level level = iDimensionArray[i].getLevel(0);
                CubeDefinition.setAttribute(element2, "name", level.getName());
                CubeDefinition.setAttribute(element2, "sort", level.getSortOrder());
                CubeDefinition.setAttribute(element2, "group-on", level.getGroupOn());
                CubeDefinition.setAttribute(element2, "group-data", level.getGroupData());
                CubeDefinition.setAttribute(element2, "derived-field", level.getDerivedFieldName());
                CubeDefinition.setAttribute(element2, "hide-totals", !level.isShowTotals());
            }
            element.addContent(element2);
        }
    }

    private void setDimensions(CubeDataSource cubeDataSource, Element element) {
        IDimension[] iDimensionArray = cubeDataSource.getHierarchies();
        for (int i = 0; i < iDimensionArray.length; ++i) {
            Element element2 = new Element("hierarchy", NS_DATASOURCE);
            element2.setAttribute("name", iDimensionArray[i].getName());
            this.saveLevels(element2, iDimensionArray[i]);
            element.addContent(element2);
        }
    }

    private void setMeasures(CubeDataSource cubeDataSource, Element element) {
        Measure[] measureArray = cubeDataSource.getMeasures();
        for (int i = 0; i < measureArray.length; ++i) {
            Element element2 = new Element("measure", NS_DATASOURCE);
            element2.setAttribute("name", measureArray[i].getName());
            element2.setAttribute("function", measureArray[i].getFunction().getName());
            String string = measureArray[i].getColumnNamePattern();
            if (StringUtil.notEmpty(string)) {
                element2.setAttribute("pattern", string);
            }
            element.addContent(element2);
        }
    }

    private void saveLevels(Element element, IDimension iDimension) {
        int n = iDimension.getLevelCount();
        for (int i = 0; i < n; ++i) {
            Level level = iDimension.getLevel(i);
            Element element2 = new Element("level", NS_DATASOURCE);
            CubeDefinition.setAttribute(element2, "name", level.getName());
            CubeDefinition.setAttribute(element2, "sort", level.getSortOrder());
            CubeDefinition.setAttribute(element2, "group-on", level.getGroupOn());
            CubeDefinition.setAttribute(element2, "group-data", level.getGroupData());
            CubeDefinition.setAttribute(element2, "derived-field", level.getDerivedFieldName());
            CubeDefinition.setAttribute(element2, "hide-totals", level.isShowTotals() ? "No" : "Yes");
            element.addContent(element2);
        }
    }

    private Level[] loadLevels(Cube cube, Element element) {
        List<Element> list = element.getChildren("level", NS_DATASOURCE);
        Level[] levelArray = new Level[list.size()];
        for (int i = 0; i < levelArray.length; ++i) {
            Element element2 = list.get(i);
            levelArray[i] = this.loadLevel(cube, element2);
        }
        return levelArray;
    }

    private Level loadLevel(Cube cube, Element element) {
        String string;
        String string2 = element.getAttributeValue("sort");
        if (StringUtil.isEmpty(string2)) {
            string2 = "Ascending";
        }
        if (StringUtil.isEmpty(string = element.getAttributeValue("group-on"))) {
            string = "Each Value";
        }
        String string3 = element.getAttributeValue("group-data");
        String string4 = element.getAttributeValue("derived-field");
        boolean bl = !"Yes".equals(element.getAttributeValue("hide-totals"));
        return cube.createLevel(element.getAttributeValue("name"), string2, string, string3, string4, bl);
    }
}

