/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.data2.olap.CubeData;
import com.elixirtech.data2.olap.CubeGroupingOptions;
import com.elixirtech.data2.olap.DataSets;
import com.elixirtech.data2.olap.IDataSet;
import com.elixirtech.data2.olap.IDimension;
import com.elixirtech.data2.olap.Index;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.RootTreeNode;
import com.elixirtech.data2.olap.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CubeGrouping {
    private final IDimension[] m_Dimensions;
    private final List<TreeNode> m_LeafNodes = new ArrayList<TreeNode>();
    private final CubeGroupingOptions m_Options;
    private Level[] m_Levels;
    private RootTreeNode m_Root;

    public CubeGrouping(CubeData cubeData, IDimension[] iDimensionArray, CubeGroupingOptions cubeGroupingOptions) {
        this.m_Dimensions = iDimensionArray;
        this.m_Options = cubeGroupingOptions;
        if (this.m_Dimensions.length > 0) {
            this.buildLevels();
            this.buildLeaves(cubeData);
        } else {
            this.m_Levels = new Level[0];
            this.m_Root = new RootTreeNode(this, cubeData.getAllDataSet());
            this.m_LeafNodes.add(this.m_Root);
        }
    }

    public List<TreeNode> getLeafNodes() {
        return Collections.unmodifiableList(this.m_LeafNodes);
    }

    public List<TreeNode> getAugmentedLeafNodes(boolean bl) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        CubeGrouping.buildNodes(this.m_Root, arrayList, bl);
        return arrayList;
    }

    private static void buildNodes(TreeNode treeNode, List<TreeNode> list, boolean bl) {
        if (bl) {
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                CubeGrouping.buildNodes(treeNode2, list, bl);
            }
            if (treeNode.isLeaf() || treeNode.isShowTotals()) {
                list.add(treeNode);
            }
        } else {
            if (treeNode.isLeaf() || treeNode.isShowTotals()) {
                list.add(treeNode);
            }
            for (TreeNode treeNode3 : treeNode.getChildren()) {
                CubeGrouping.buildNodes(treeNode3, list, bl);
            }
        }
    }

    private void buildLevels() {
        ArrayList<Level> arrayList = new ArrayList<Level>();
        for (int i = 0; i < this.m_Dimensions.length; ++i) {
            int n = this.m_Dimensions[i].getLevelCount();
            for (int j = 0; j < n; ++j) {
                arrayList.add(this.m_Dimensions[i].getLevel(j));
            }
        }
        this.m_Levels = new Level[arrayList.size()];
        arrayList.toArray(this.m_Levels);
    }

    private void buildLeaves(CubeData cubeData) {
        this.m_Root = new RootTreeNode(this, cubeData.getAllDataSet());
        List<TreeNode> list = new ArrayList<TreeNode>();
        list.add(this.m_Root);
        for (int i = 0; i < this.m_Dimensions.length; ++i) {
            list = this.buildLeafGroups(cubeData, list, this.m_Dimensions[i]);
        }
        this.m_LeafNodes.addAll(list);
    }

    public void setTitle(String string) {
        this.m_Root.setName(string);
    }

    public int getLevelCount() {
        return this.m_Levels.length;
    }

    public Level getLevel(int n) {
        return this.m_Levels[n];
    }

    public int getDepth() {
        return this.m_Levels.length;
    }

    public CubeGroupingOptions getOptions() {
        return this.m_Options;
    }

    public RootTreeNode getRoot() {
        return this.m_Root;
    }

    private List<TreeNode> buildLeafGroups(CubeData cubeData, List<TreeNode> list, IDimension iDimension) {
        DataSets dataSets = cubeData.getDataSets(iDimension);
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        for (TreeNode treeNode : list) {
            Index index = treeNode.getTreeIndex();
            IDataSet[] iDataSetArray = dataSets.getDataSets();
            boolean bl = this.m_Options.isRemoveEmpty();
            for (int i = 0; i < iDataSetArray.length; ++i) {
                Index index2 = index.intersection(iDataSetArray[i].getIndex());
                if (bl && index2.isEmpty()) continue;
                TreeNode treeNode2 = iDataSetArray[i].buildTreeNode(treeNode, index2);
                treeNode2.buildLeaves(arrayList);
            }
        }
        return arrayList;
    }
}

