/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.output.DSWrapper;
import com.elixirtech.data2.output.IDataStore2;
import com.elixirtech.data2.output.OutputHandler;
import com.elixirtech.repository.RMLFileObject;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class BinaryDataStore
implements IDataStore2 {
    public static final byte[] BINARY_MARKER = new byte[]{100, 115, 98, 105};
    public static final byte[] VERSION_MARKER = new byte[]{0, 1, 0, 0};
    private String m_Name;
    private DataStore m_DataStore;
    private String m_URL;
    private DataOutputStream m_OutputStream;
    private RMLFileObject m_FileObject;
    private PushContext m_Context;
    private DataSchema m_Schema;
    private boolean m_Compress;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(BinaryDataStore.class);

    public BinaryDataStore() {
    }

    public BinaryDataStore(OutputStream outputStream, boolean bl) throws IOException {
        this.m_Compress = bl;
        this.configureOutputStream(outputStream);
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(new DSWrapper(this));
        }
        return null;
    }

    @Override
    public void setContext(PushContext pushContext) {
        this.m_Context = pushContext;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public void setName(String string) {
        this.m_Name = string;
    }

    @Override
    public DataStore getDataStore() {
        return this.m_DataStore;
    }

    @Override
    public void setDataStore(DataStore dataStore) {
        this.m_DataStore = dataStore;
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_URL);
        return argumentMap.getParameters();
    }

    public void setURL(String string) {
        this.m_URL = string;
    }

    public String getURL() {
        return this.m_URL;
    }

    public void setCompress(boolean bl) {
        this.m_Compress = bl;
    }

    public boolean getCompress() {
        return this.m_Compress;
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.m_Schema = iDataSource.getSchema();
        if (this.m_OutputStream == null) {
            this.initOutputStream();
        }
        try {
            this.m_Schema.write(this.m_OutputStream);
        }
        catch (IOException iOException) {
            m_Log.error((Object)"IOException in startData", (Throwable)iOException);
            throw new RuntimeException("IOException in startData", iOException);
        }
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
        try {
            this.m_OutputStream.writeByte(67);
            this.m_OutputStream.writeByte(83);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataGroup.write(dataOutputStream);
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.m_OutputStream.writeInt(byArray.length);
            this.m_OutputStream.write(byArray);
        }
        catch (IOException iOException) {
            m_Log.error((Object)"IOException in startGroup", (Throwable)iOException);
            throw new RuntimeException("IOException in startGroup", iOException);
        }
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        try {
            this.m_OutputStream.writeByte(82);
            dataRecord.write(this.m_OutputStream);
            return this.m_Context != null ? !this.m_Context.isAborted() : true;
        }
        catch (IOException iOException) {
            m_Log.error((Object)"IOException in processRecord", (Throwable)iOException);
            throw new RuntimeException("IOException in processRecord", iOException);
        }
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
        try {
            this.m_OutputStream.writeByte(67);
            this.m_OutputStream.writeByte(69);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataGroup.write(dataOutputStream);
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.m_OutputStream.writeInt(byArray.length);
            this.m_OutputStream.write(byArray);
        }
        catch (IOException iOException) {
            m_Log.error((Object)"IOException in endGroup", (Throwable)iOException);
            throw new RuntimeException("IOException in endGroup", iOException);
        }
    }

    @Override
    public void endData(IDataSource iDataSource) {
        if (this.m_OutputStream != null) {
            try {
                this.m_OutputStream.writeByte(88);
                this.m_OutputStream.close();
                this.m_URL = null;
            }
            catch (IOException iOException) {
                m_Log.error((Object)"IOException in endData", (Throwable)iOException);
                throw new RuntimeException("IOException in endData", iOException);
            }
        }
    }

    protected void initOutputStream() {
        OutputStream outputStream = null;
        try {
            Object object = this.m_Context.substitute(this.m_URL);
            if (!OutputHandler.hasExtension((String)object)) {
                object = (String)object + ".bin";
            }
            outputStream = OutputHandler.getOutputStream((String)object, false);
            this.configureOutputStream(outputStream);
        }
        catch (IOException iOException) {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2) {
                    outputStream = null;
                }
            }
            m_Log.error((Object)"IOException in initOutputStream", (Throwable)iOException);
            throw new RuntimeException("IOException in initOutputStream", iOException);
        }
    }

    private void configureOutputStream(OutputStream outputStream) throws IOException {
        outputStream.write(BINARY_MARKER);
        outputStream.write(VERSION_MARKER);
        outputStream.write(this.m_Compress ? 67 : 85);
        outputStream.flush();
        if (this.m_Compress) {
            outputStream = new DeflaterOutputStream(outputStream, new Deflater(9));
        }
        this.m_OutputStream = new DataOutputStream(outputStream);
    }
}

