/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.output.BaseJDBCDataStore;
import com.elixirtech.data2.output.DSWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JDBCJNDIStore
extends BaseJDBCDataStore {
    public ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JDBCJNDIStore.class);
    private String m_URL;
    private String m_User;
    private String m_Password;
    private String m_ContextFactory;
    private String m_Resource;

    @Override
    public ElxLoggerJ getLog() {
        return this.m_Log;
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_URL);
        argumentMap.extractParameters(this.m_User);
        argumentMap.extractParameters(this.m_Password);
        argumentMap.extractParameters(this.m_ContextFactory);
        argumentMap.extractParameters(this.m_Resource);
        return argumentMap.getParameters();
    }

    public String getPassword() {
        return this.m_Password;
    }

    public void setPassword(String string) {
        this.m_Password = string;
    }

    public String getURL() {
        return this.m_URL;
    }

    public void setURL(String string) {
        this.m_URL = string;
    }

    public String getUser() {
        return this.m_User;
    }

    public void setUser(String string) {
        this.m_User = string;
    }

    public String getContextFactory() {
        return this.m_ContextFactory;
    }

    public void setContextFactory(String string) {
        this.m_ContextFactory = string;
    }

    public String getResource() {
        return this.m_Resource;
    }

    public void setResource(String string) {
        this.m_Resource = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JDBCJNDIStore)) {
            return false;
        }
        JDBCJNDIStore jDBCJNDIStore = (JDBCJNDIStore)object;
        return JDBCJNDIStore.equal(this.m_ContextFactory, jDBCJNDIStore.m_ContextFactory) && JDBCJNDIStore.equal(this.m_URL, jDBCJNDIStore.m_URL) && JDBCJNDIStore.equal(this.m_Resource, jDBCJNDIStore.m_Resource);
    }

    private static boolean equal(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    private static void put(Hashtable<Object, Object> hashtable, String string, String string2) {
        if (StringUtil.notEmpty(string2)) {
            hashtable.put(string, string2);
        }
    }

    @Override
    protected Connection openConnection() {
        InitialContext initialContext = null;
        String string = this.m_Context.substitute(this.m_ContextFactory);
        String string2 = this.m_Context.substitute(this.m_URL);
        String string3 = this.m_Context.substitute(this.m_User);
        String string4 = this.m_Context.substitute(this.m_Password);
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        JDBCJNDIStore.put(hashtable, "java.naming.factory.initial", this.m_Context.substitute(string));
        JDBCJNDIStore.put(hashtable, "java.naming.provider.url", this.m_Context.substitute(string2));
        JDBCJNDIStore.put(hashtable, "java.naming.security.principal", this.m_Context.substitute(string3));
        JDBCJNDIStore.put(hashtable, "java.naming.security.credentials", this.m_Context.substitute(string4));
        String string5 = this.m_Context.substitute(this.m_Resource);
        try {
            initialContext = new InitialContext(hashtable);
            DataSource dataSource = null;
            Object object = initialContext.lookup(string5);
            if (object instanceof DataSource) {
                dataSource = (DataSource)object;
                Connection connection = dataSource.getConnection();
                return connection;
            }
            try {
                throw new SQLException("Resource " + string5 + " does not identify a DataSource");
            }
            catch (Exception exception) {
                object = new SQLException("Unable to get JNDI Connection to " + string5);
                ((Throwable)object).initCause(exception);
                throw new RuntimeException(exception.getMessage(), (Throwable)object);
            }
        }
        finally {
            try {
                if (initialContext != null) {
                    initialContext.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(new DSWrapper(this));
        }
        return null;
    }
}

