/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import com.elixirtech.arch.Elixir;
import com.elixirtech.data.JSONSerializers;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.output.DSWrapper;
import com.elixirtech.data2.output.IDataStore2;
import com.elixirtech.data2.output.RepositoryOutput;
import com.elixirtech.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;

public class JSONDataStore
implements IDataStore2 {
    static final boolean isRepositoryExplorer = false;
    private PushContext m_Context;
    private String m_Name;
    private DataStore m_DataStore;
    private String m_URL;
    private int m_Rows;
    private int m_MaxRows = -1;
    private boolean m_KeepRowCount;
    private Writer m_Writer;
    private boolean m_NeedsAutoClose = false;

    public JSONDataStore() {
    }

    public JSONDataStore(OutputStream outputStream) throws IOException {
        this.m_Writer = new OutputStreamWriter(outputStream, "UTF-8");
    }

    public JSONDataStore(Writer writer) {
        this.m_Writer = writer;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(new DSWrapper(this));
        }
        return null;
    }

    @Override
    public void setContext(PushContext pushContext) {
        this.m_Context = pushContext;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public void setName(String string) {
        this.m_Name = string;
    }

    @Override
    public DataStore getDataStore() {
        return this.m_DataStore;
    }

    @Override
    public void setDataStore(DataStore dataStore) {
        this.m_DataStore = dataStore;
    }

    public void setMaxRows(int n) {
        this.m_MaxRows = n;
    }

    public int getMaxRows() {
        return this.m_MaxRows;
    }

    public void setKeepRowCount(boolean bl) {
        this.m_KeepRowCount = bl;
    }

    public boolean isKeepRowCount() {
        return this.m_KeepRowCount;
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_URL);
        return argumentMap.getParameters();
    }

    public void setURL(String string) {
        this.m_URL = string;
    }

    @Override
    public void startData(IDataSource iDataSource) {
        String string = JSONSerializers.schemaJsonString(iDataSource.getSchema());
        this.m_Rows = 0;
        try {
            if (this.m_Writer == null) {
                this.initWriter();
            }
            this.m_Writer.append("{");
            this.m_Writer.append("\"schema\": " + string);
            this.m_Writer.append(",\n");
            this.m_Writer.append("\"data\": [");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error in startData: " + iOException, iOException);
        }
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        String string = JSONSerializers.dataRecordJsonString(dataRecord);
        ++this.m_Rows;
        try {
            if (this.m_Rows == 1) {
                this.m_Writer.append("\n ");
            } else {
                this.m_Writer.append(",\n ");
            }
            this.m_Writer.append(string);
            return this.m_Context != null ? !this.m_Context.isAborted() : true;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error in processRecord: " + exception, exception);
        }
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
    }

    @Override
    public void endData(IDataSource iDataSource) {
        try {
            this.m_Writer.append("\n]\n");
            this.m_Writer.append("}");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error in endData: " + iOException, iOException);
        }
        if (this.m_NeedsAutoClose) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    FileUtil.close(JSONDataStore.this.m_Writer);
                }
            };
            runnable.run();
        }
    }

    private void initWriter() throws IOException {
        this.m_NeedsAutoClose = true;
        Object object = this.m_Context.substitute(this.m_URL);
        if (((String)object).indexOf(46) < 0) {
            object = (String)object + ".json";
        }
        if (((String)object).startsWith("repository:")) {
            String string = ((String)object).substring(11);
            OutputStream outputStream = ((RepositoryOutput)Elixir.get(RepositoryOutput.class)).getOutputStream(string, false);
            this.m_Writer = new OutputStreamWriter(outputStream, "UTF-8");
        } else {
            File file = new File(new URL((String)object).getFile());
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.m_Writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        }
    }
}

