/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.xml.XMLWriter;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.output.DSWrapper;
import com.elixirtech.data2.output.IDataStore2;
import com.elixirtech.data2.output.OutputHandler;
import com.elixirtech.data2.output.XMLTransformer;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.util.FileUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLCompressedDataStore
implements IDataStore2 {
    static final boolean isRepositoryExplorer = false;
    private PushContext m_Context;
    private ContentHandler m_Handler;
    private String m_Name;
    private DataStore m_DataStore;
    private String m_URL;
    private String m_XSLT;
    private boolean m_Indent;
    private int m_Rows;
    private int m_MaxRows = -1;
    private boolean m_KeepRowCount;
    private Writer m_Writer;
    private OutputStream m_OutputStream;
    private RMLFileObject m_FileObject;
    private static final String URI = Data2Constants.NS_DATASOURCE.getURI();
    private static final Attributes EMPTY_ATTRS = new AttributesImpl();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(XMLCompressedDataStore.class);

    public static XMLWriter buildXMLWriter(Writer writer) {
        XMLWriter xMLWriter = new XMLWriter(writer);
        xMLWriter.forceNSDecl(URI, "");
        return xMLWriter;
    }

    public XMLCompressedDataStore() {
    }

    public XMLCompressedDataStore(Writer writer) {
        this(XMLCompressedDataStore.buildXMLWriter(writer));
    }

    public XMLCompressedDataStore(String string, OutputStream outputStream) throws IOException {
        this.m_XSLT = string;
        this.m_OutputStream = outputStream;
        try {
            XMLTransformer xMLTransformer = new XMLTransformer(this.m_XSLT, this.m_OutputStream);
            this.m_Handler = xMLTransformer.getContentHandler();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            IOException iOException = new IOException("XSLT error: " + transformerConfigurationException);
            iOException.initCause(transformerConfigurationException);
            throw iOException;
        }
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(new DSWrapper(this));
        }
        return null;
    }

    public XMLCompressedDataStore(ContentHandler contentHandler) {
        this.m_Handler = contentHandler;
    }

    @Override
    public void setContext(PushContext pushContext) {
        this.m_Context = pushContext;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public void setName(String string) {
        this.m_Name = string;
    }

    @Override
    public DataStore getDataStore() {
        return this.m_DataStore;
    }

    @Override
    public void setDataStore(DataStore dataStore) {
        this.m_DataStore = dataStore;
    }

    public void setMaxRows(int n) {
        this.m_MaxRows = n;
    }

    public int getMaxRows() {
        return this.m_MaxRows;
    }

    public void setKeepRowCount(boolean bl) {
        this.m_KeepRowCount = bl;
    }

    public boolean isKeepRowCount() {
        return this.m_KeepRowCount;
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_URL);
        argumentMap.extractParameters(this.m_XSLT);
        return argumentMap.getParameters();
    }

    public void setURL(String string) {
        this.m_URL = string;
    }

    public void setXSLT(String string) {
        this.m_XSLT = string;
    }

    public void setIndent(boolean bl) {
        this.m_Indent = bl;
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.m_Rows = 0;
        if (this.m_Handler == null) {
            try {
                this.initHandler();
            }
            catch (Exception exception) {
                throw new RuntimeException("Error initializing handler: " + exception, exception);
            }
        }
        try {
            this.m_Handler.startDocument();
            this.m_Handler.startPrefixMapping("", URI);
            AttributesImpl attributesImpl = new AttributesImpl();
            String string = this.m_Name;
            if (string == null) {
                string = iDataSource.getName();
            }
            if (string == null) {
                string = "data";
            }
            this.setAttr(attributesImpl, "name", string);
            this.setAttr(attributesImpl, "type", "Data");
            this.m_Handler.startElement(URI, "datasource", "datasource", attributesImpl);
            DataSchema dataSchema = iDataSource.getSchema();
            AttributesImpl attributesImpl2 = new AttributesImpl();
            this.setAttr(attributesImpl2, "case-sensitive", dataSchema.isCaseSensitive() ? "Yes" : "No");
            String string2 = dataSchema.getDateFormat();
            this.setAttr(attributesImpl2, "date-format", string2);
            String string3 = dataSchema.getTimeFormat();
            this.setAttr(attributesImpl2, "time-format", string3);
            String string4 = dataSchema.getTimestampFormat();
            this.setAttr(attributesImpl2, "timestamp-format", string4);
            this.m_Handler.startElement(URI, "schema", "schema", attributesImpl2);
            int n = dataSchema.getColumnCount();
            for (int i = 0; i < n; ++i) {
                AttributesImpl attributesImpl3 = new AttributesImpl();
                this.setAttr(attributesImpl3, "name", dataSchema.getColumnName(i));
                this.setAttr(attributesImpl3, "type", dataSchema.getColumnType(i).getTypeName());
                this.m_Handler.startElement(URI, "column", "column", attributesImpl3);
                this.m_Handler.endElement(URI, "column", "column");
            }
            this.m_Handler.endElement(URI, "schema", "schema");
            this.m_Handler.startElement(URI, "data", "data", EMPTY_ATTRS);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Error in startData: " + sAXException);
        }
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            this.setAttr(attributesImpl, "level", Integer.toString(dataGroup.getLevel()));
            String string = dataGroup.getName();
            if (StringUtil.isEmpty(string)) {
                string = "unknown";
            }
            this.setAttr(attributesImpl, "name", string);
            this.m_Handler.startElement(URI, "g", "g", attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Error in startGroup: " + sAXException);
        }
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        if (this.m_MaxRows >= 0) {
            if (this.m_Rows >= this.m_MaxRows) {
                return this.m_KeepRowCount;
            }
            ++this.m_Rows;
        }
        try {
            this.m_Handler.startElement(URI, "r", "r", EMPTY_ATTRS);
            DataSchema dataSchema = dataRecord.getSchema();
            int n = dataSchema.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String string = this.getData(dataRecord, i);
                this.m_Handler.startElement(URI, "f", "f", EMPTY_ATTRS);
                this.m_Handler.characters(string.toCharArray(), 0, string.length());
                this.m_Handler.endElement(URI, "f", "f");
            }
            this.m_Handler.endElement(URI, "r", "r");
            return this.m_Context != null ? !this.m_Context.isAborted() : true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Error in processRecord: " + exception);
        }
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
        try {
            this.m_Handler.endElement(URI, "g", "g");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Error in endGroup: " + sAXException);
        }
    }

    @Override
    public void endData(IDataSource iDataSource) {
        try {
            this.m_Handler.endElement(URI, "data", "data");
            this.m_Handler.endElement(URI, "datasource", "datasource");
            this.m_Handler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Error in endData: " + sAXException, sAXException);
        }
        this.closeOutput();
    }

    private void closeOutput() {
        FileUtil.close(this.m_Writer);
        FileUtil.close(this.m_OutputStream);
    }

    private String getData(DataRecord dataRecord, int n) throws IOException {
        DataSchema dataSchema = dataRecord.getSchema();
        Object object = dataRecord.getData(n);
        DataType dataType = dataSchema.getColumnType(n);
        return dataSchema.format(dataType, object);
    }

    private void setAttr(AttributesImpl attributesImpl, String string, String string2) {
        attributesImpl.addAttribute("", string, string, "CDATA", string2);
    }

    private void initHandler() throws IOException, TransformerConfigurationException {
        Object object = this.m_Context.substitute(this.m_URL);
        String string = this.m_Context.substitute(this.m_XSLT);
        if (((String)object).indexOf(46) < 0) {
            object = (String)object + ".xml";
        }
        String string2 = ((String)object).substring(11);
        this.m_OutputStream = OutputHandler.getOutputStream(string2, false);
        if (StringUtil.isEmpty(string)) {
            m_Log.debug((Object)("Simple XML output to " + (String)object));
            this.m_Writer = new OutputStreamWriter(this.m_OutputStream, "UTF-8");
            this.m_Handler = new XMLWriter(this.m_Writer);
            this.m_OutputStream = null;
        } else {
            m_Log.debug((Object)("Transformed XML output using " + string + " to " + (String)object));
            XMLTransformer xMLTransformer = new XMLTransformer(string, this.m_OutputStream);
            this.m_Handler = xMLTransformer.getContentHandler();
        }
    }
}

