/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ContentHandler;

public class XMLTransformer {
    private TransformerHandler m_TransformerHandler;

    public XMLTransformer(String string, OutputStream outputStream) throws IOException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (transformerFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(URLLoader.getInputStream(string));
            StreamSource streamSource = new StreamSource(bufferedInputStream);
            streamSource.setSystemId(string);
            this.m_TransformerHandler = sAXTransformerFactory.newTransformerHandler(streamSource);
            this.m_TransformerHandler.setResult(new StreamResult(outputStream));
        }
    }

    public XMLTransformer(File file, OutputStream outputStream) throws IOException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (transformerFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
            StreamSource streamSource = new StreamSource(new FileInputStream(file));
            streamSource.setSystemId(FileUtil.asURL(file));
            this.m_TransformerHandler = sAXTransformerFactory.newTransformerHandler(streamSource);
            this.m_TransformerHandler.setResult(new StreamResult(outputStream));
        }
    }

    public ContentHandler getContentHandler() {
        return this.m_TransformerHandler;
    }
}

