/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.arch.param.Template;
import com.elixirtech.arch.param.Template$;
import com.elixirtech.data.RichSchema$;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.output.DSWrapper;
import com.elixirtech.data2.output.OutputHandler$;
import com.elixirtech.data2.output.ScalaDataStore;
import com.elixirtech.data2.output.XlsxDataStore$Lookup$;
import com.elixirtech.opc.DateTimeUtil$;
import com.elixirtech.opc.xls.Location;
import com.elixirtech.opc.xls.Row;
import com.elixirtech.opc.xls.Sheet;
import com.elixirtech.opc.xls.Styles;
import com.elixirtech.opc.xls.Workbook;
import com.elixirtech.opc.xls.style.Format;
import com.elixirtech.opc.xls.style.XF;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class XlsxDataStore
implements ScalaDataStore,
SLF4J,
LoggingHelper {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(XlsxDataStore.class.getDeclaredField("logger$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(XlsxDataStore.class.getDeclaredField("Lookup$lzy1"));
    private volatile Object logger$lzy1;
    private final Config config = (Config)Elixir$.MODULE$.get(Config.class);
    private final int MaxRows = this.config().getInt("elixir.data.store.xlsx.max-rows");
    private final String DoubleFormatString = this.config().getString("elixir.data.store.xlsx.format.double");
    private final String TimestampFormatString = this.config().getString("elixir.data.store.xlsx.format.timestamp");
    private final com.elixirtech.data2.attributes.Format DefaultDoubleFormat = new com.elixirtech.data2.attributes.Format(this.DoubleFormatString());
    private final com.elixirtech.data2.attributes.Format DefaultLongFormat = new com.elixirtech.data2.attributes.Format("0");
    private final com.elixirtech.data2.attributes.Format DefaultDateFormat = new com.elixirtech.data2.attributes.Format("14");
    private final com.elixirtech.data2.attributes.Format DefaultTimeFormat = new com.elixirtech.data2.attributes.Format("21");
    private final com.elixirtech.data2.attributes.Format DefaultTimestampFormat = new com.elixirtech.data2.attributes.Format(this.TimestampFormatString());
    private String url = null;
    private DataStore datastore = null;
    private String dsName = null;
    private Option<OutputStream> outputStream = None$.MODULE$;
    private Option<PushContext> context = None$.MODULE$;
    private DataSchema schema = null;
    private Template sheetName = Template$.MODULE$.apply("Sheet1");
    private Workbook workbook = new Workbook();
    private Option<Sheet> sheet = None$.MODULE$;
    private HashSet<String> sheetNames = new HashSet();
    private int row = 0;
    private int groupedSheetsLevel = 1;
    private boolean firstRowHeader = false;
    public Stack<DataGroup> com$elixirtech$data2$output$XlsxDataStore$$groupStack = new Stack(Stack$.MODULE$.$lessinit$greater$default$1());
    private final Styles styles = this.workbook.getStyles();
    private volatile Object Lookup$lzy1;

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Config config() {
        return this.config;
    }

    public int MaxRows() {
        return this.MaxRows;
    }

    public String DoubleFormatString() {
        return this.DoubleFormatString;
    }

    public String TimestampFormatString() {
        return this.TimestampFormatString;
    }

    public com.elixirtech.data2.attributes.Format DefaultDoubleFormat() {
        return this.DefaultDoubleFormat;
    }

    public com.elixirtech.data2.attributes.Format DefaultLongFormat() {
        return this.DefaultLongFormat;
    }

    public com.elixirtech.data2.attributes.Format DefaultDateFormat() {
        return this.DefaultDateFormat;
    }

    public com.elixirtech.data2.attributes.Format DefaultTimeFormat() {
        return this.DefaultTimeFormat;
    }

    public com.elixirtech.data2.attributes.Format DefaultTimestampFormat() {
        return this.DefaultTimestampFormat;
    }

    public Styles styles() {
        return this.styles;
    }

    @Override
    public <T> T getAdapter(Class<T> cls) {
        Class<T> clazz = cls;
        Class<IDataSource> clazz2 = IDataSource.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return cls.cast(new DSWrapper(this));
        }
        return null;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = Some$.MODULE$.apply((Object)os);
    }

    @Override
    public void setContext(PushContext cxt) {
        this.context = Some$.MODULE$.apply((Object)cxt);
    }

    @Override
    public String getName() {
        return this.dsName;
    }

    @Override
    public void setName(String n) {
        this.dsName = n;
    }

    public void setURL(String u) {
        this.url = u;
    }

    public String getURL() {
        return this.url;
    }

    public void setSheetName(String sn) {
        this.sheetName = Template$.MODULE$.apply(sn);
    }

    public int getSheetGroupLevel() {
        return this.groupedSheetsLevel;
    }

    public void setSheetGroupLevel(int level) {
        this.groupedSheetsLevel = level;
    }

    public boolean isFirstRowHeader() {
        return this.firstRowHeader;
    }

    public void setFirstRowHeader(boolean b) {
        this.firstRowHeader = b;
    }

    @Override
    public DataStore getDataStore() {
        return this.datastore;
    }

    @Override
    public void setDataStore(DataStore store) {
        this.datastore = store;
    }

    @Override
    public void startData(IDataSource src) {
        this.schema = src.getSchema();
    }

    @Override
    public void startGroup(DataGroup group) {
        this.com$elixirtech$data2$output$XlsxDataStore$$groupStack.push((Object)group);
        if (group.getLevel() == this.groupedSheetsLevel - 1) {
            String sn = this.ensureUnique(this.ensureValidChars(this.sheetName.substitute(this.Lookup().lift())));
            this.sheetNames.add((Object)sn);
            this.sheet = Some$.MODULE$.apply((Object)this.workbook.nextSheet(sn));
            this.row = 0;
            this.outputHeader();
            return;
        }
    }

    @Override
    public boolean processRecord(DataRecord record) {
        if (this.sheet.isEmpty()) {
            String sn = this.ensureUnique(this.ensureValidChars(this.sheetName.substitute(this.Lookup().lift())));
            this.sheetNames.add((Object)sn);
            this.sheet = Some$.MODULE$.apply((Object)this.workbook.nextSheet(sn));
            this.row = 0;
            this.outputHeader();
        }
        try {
            this.output(record.getData());
            Option<PushContext> option = this.context;
            if (option instanceof Some) {
                PushContext cxt = (PushContext)((Some)option).value();
                return !cxt.isAborted();
            }
            if (None$.MODULE$.equals(option)) {
                return true;
            }
            throw new MatchError(option);
        }
        catch (Exception ex) {
            this.error(() -> this.processRecord$$anonfun$1(ex), ex, Line$.MODULE$.apply(111), FullName$.MODULE$.apply("com.elixirtech.data2.output.XlsxDataStore.processRecord"));
            return false;
        }
    }

    @Override
    public void endGroup(DataGroup group) {
        this.com$elixirtech$data2$output$XlsxDataStore$$groupStack.pop();
    }

    @Override
    public void endData(IDataSource src) {
        block6: {
            try {
                Option<OutputStream> option = this.outputStream;
                if (option instanceof Some) {
                    OutputStream os = (OutputStream)((Some)option).value();
                    this.workbook.output(os);
                    break block6;
                }
                if (None$.MODULE$.equals(option)) {
                    Option<PushContext> option2 = this.context;
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new IllegalStateException("Context undefined");
                        }
                        throw new MatchError(option2);
                    }
                    PushContext c = (PushContext)((Some)option2).value();
                    PushContext cxt = c;
                    String urlString = this.withExt(cxt.substitute(this.url), ".xlsx");
                    ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
                        OutputStream os = (OutputStream)arm.manage((Object)this.getOutputStream(urlString));
                        this.workbook.output(os);
                    });
                    break block6;
                }
                throw new MatchError(option);
            }
            catch (IOException ex) {
                throw new DataException("Error opening output file: " + ex, ex);
            }
        }
    }

    public OutputStream getOutputStream(String urlString) {
        return OutputHandler$.MODULE$.getOutputStream(urlString, false);
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap map = new ArgumentMap();
        map.extractParameters(this.url);
        return map.getParameters();
    }

    public void outputHeader() {
        if (this.firstRowHeader) {
            this.output((Object[])((IterableOnceOps)RichSchema$.MODULE$.schema2rich(this.schema).items().map((Function1 & Serializable)_$1 -> _$1.name())).toArray(ClassTag$.MODULE$.apply(Object.class)));
            return;
        }
    }

    public void output(Object[] data) {
        if (this.row < this.MaxRows()) {
            Row newRow = new Row(this.row);
            Object object = Predef$.MODULE$.refArrayOps(data);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)((JProcedure1 & Serializable)arg_0 -> this.output$$anonfun$1(newRow, arg_0)));
            ++this.row;
            this.sheet.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.addRow(newRow));
            return;
        }
        this.sheet = None$.MODULE$;
        this.row = 0;
        DataRecord rec = new DataRecord(this.schema, data);
        this.processRecord(rec);
    }

    private String withExt(String name, String ext) {
        if (!name.endsWith(ext)) {
            return name + ext;
        }
        return name;
    }

    private String ensureUnique(String s) {
        if (this.sheetNames.contains((Object)s)) {
            String buff = s.endsWith("1") ? s.substring(0, s.length() - 1) : s;
            int idx = 1;
            while (true) {
                String test = buff + idx;
                if (!this.sheetNames.contains((Object)test)) {
                    return test;
                }
                ++idx;
            }
        }
        return s;
    }

    private String ensureValidChars(String name) {
        String ret = name.replace('/', '_').replace('\\', '_').replace('?', '_').replace('*', '_').replace('[', '_').replace(']', '_').replace(':', '_').replace('{', '_');
        if (ret.length() > 31) {
            return ret.substring(0, 31);
        }
        return ret;
    }

    public final XlsxDataStore$Lookup$ Lookup() {
        Object object = this.Lookup$lzy1;
        if (object instanceof XlsxDataStore$Lookup$) {
            return (XlsxDataStore$Lookup$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (XlsxDataStore$Lookup$)this.Lookup$lzyINIT1();
    }

    private Object Lookup$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Lookup$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    XlsxDataStore$Lookup$ xlsxDataStore$Lookup$ = null;
                    try {
                        xlsxDataStore$Lookup$ = new XlsxDataStore$Lookup$(this);
                        object2 = xlsxDataStore$Lookup$ == null ? LazyVals.NullValue$.MODULE$ : xlsxDataStore$Lookup$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Lookup$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return xlsxDataStore$Lookup$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final Object processRecord$$anonfun$1(Exception ex$1) {
        return "Error processing record " + this.row + ": " + ex$1;
    }

    private final com.elixirtech.data2.attributes.Format $anonfun$1() {
        return this.DefaultDoubleFormat();
    }

    private final com.elixirtech.data2.attributes.Format $anonfun$2() {
        return this.DefaultLongFormat();
    }

    private final com.elixirtech.data2.attributes.Format $anonfun$3() {
        return this.DefaultDateFormat();
    }

    private final com.elixirtech.data2.attributes.Format $anonfun$4() {
        return this.DefaultTimeFormat();
    }

    private final com.elixirtech.data2.attributes.Format $anonfun$5() {
        return this.DefaultTimestampFormat();
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ void output$$anonfun$1(Row newRow$1, Tuple2 x$1) {
        block9: {
            block10: {
                var3_3 = x$1;
                if (var3_3 == null) break block9;
                field = var3_3._1();
                i = BoxesRunTime.unboxToInt((Object)var3_3._2());
                location = new Location(i, this.row);
                var7_7 = field;
                if (var7_7 instanceof String) {
                    s = (String)var7_7;
                    value = this.workbook.newTextCell(location, s);
                    newRow$1.addCell(value);
                    return;
                }
                if (!(var7_7 instanceof Number)) break block10;
                n = (Number)var7_7;
                d = n.doubleValue();
                if (Double.isNaN(d)) {
                    value = this.workbook.newTextCell(location, "");
                    newRow$1.addCell(value);
                    return;
                }
                xf = new XF();
                value = this.workbook.newNumberCell(location, d);
                v0 = dt = this.schema.getColumnType(i);
                var17_16 = DataType.DOUBLE;
                if (!(v0 == null ? var17_16 != null : v0.equals(var17_16) == false)) ** GOTO lbl-1000
                v1 = dt;
                var18_17 = DataType.DECIMAL;
                if (!(v1 != null ? v1.equals(var18_17) == false : var18_17 != null)) lbl-1000:
                // 2 sources

                {
                    f = (com.elixirtech.data2.attributes.Format)Option$.MODULE$.apply((Object)this.schema.getColumn((int)i).attrs.getAttribute(com.elixirtech.data2.attributes.Format.class)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$1(), ()Lcom/elixirtech/data2/attributes/Format;)((XlsxDataStore)this));
                    xf.setFormat(new Format(f.getFormat()));
                } else {
                    f = (com.elixirtech.data2.attributes.Format)Option$.MODULE$.apply((Object)this.schema.getColumn((int)i).attrs.getAttribute(com.elixirtech.data2.attributes.Format.class)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$2(), ()Lcom/elixirtech/data2/attributes/Format;)((XlsxDataStore)this));
                    xf.setFormat(new Format(f.getFormat()));
                }
                value.setStyle(this.styles().getXFIndex(xf));
                newRow$1.addCell(value);
                return;
            }
            if (var7_7 instanceof Date) {
                d = (Date)var7_7;
                xf = new XF();
                var24_23 = dt = this.schema.getColumnType(i);
                v2 = DataType.DATE;
                var25_24 = var24_23;
                if (!(v2 != null ? v2.equals(var25_24) == false : var25_24 != null)) {
                    days = DateTimeUtil$.MODULE$.getDaysSince1900(d);
                    value = this.workbook.newNumberCell(location, Int$.MODULE$.int2long(days));
                    f = (com.elixirtech.data2.attributes.Format)Option$.MODULE$.apply((Object)this.schema.getColumn((int)i).attrs.getAttribute(com.elixirtech.data2.attributes.Format.class)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$3(), ()Lcom/elixirtech/data2/attributes/Format;)((XlsxDataStore)this));
                    xf.setFormat(new Format(f.getFormat()));
                    value.setStyle(this.styles().getXFIndex(xf));
                    newRow$1.addCell(value);
                    return;
                }
                v3 = DataType.TIME;
                var29_28 = var24_23;
                if (!(v3 != null ? v3.equals(var29_28) == false : var29_28 != null)) {
                    secs = DateTimeUtil$.MODULE$.getTimeSinceMidnight(d);
                    value = this.workbook.newNumberCell(location, secs);
                    f = (com.elixirtech.data2.attributes.Format)Option$.MODULE$.apply((Object)this.schema.getColumn((int)i).attrs.getAttribute(com.elixirtech.data2.attributes.Format.class)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$4(), ()Lcom/elixirtech/data2/attributes/Format;)((XlsxDataStore)this));
                    xf.setFormat(new Format(f.getFormat()));
                    value.setStyle(this.styles().getXFIndex(xf));
                    newRow$1.addCell(value);
                    return;
                }
                v4 = DataType.TIMESTAMP;
                var34_32 = var24_23;
                if (!(v4 != null ? v4.equals(var34_32) == false : var34_32 != null)) {
                    ts = DateTimeUtil$.MODULE$.getTimestamp(d);
                    value = this.workbook.newNumberCell(location, ts);
                    f = (com.elixirtech.data2.attributes.Format)Option$.MODULE$.apply((Object)this.schema.getColumn((int)i).attrs.getAttribute(com.elixirtech.data2.attributes.Format.class)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$5(), ()Lcom/elixirtech/data2/attributes/Format;)((XlsxDataStore)this));
                    xf.setFormat(new Format(f.getFormat()));
                    value.setStyle(this.styles().getXFIndex(xf));
                    newRow$1.addCell(value);
                    return;
                }
                value = this.workbook.newTextCell(location, "Unexpected date: " + d);
                return;
            }
            if (var7_7 instanceof Boolean) {
                b = (Boolean)var7_7;
                value = this.workbook.newBooleanCell(location, b);
                newRow$1.addCell(value);
                return;
            }
            s = this.schema.format(this.schema.getColumnType(i), field);
            value = this.workbook.newTextCell(location, s);
            newRow$1.addCell(value);
            return;
        }
        throw new MatchError((Object)var3_3);
    }

    public static final String com$elixirtech$data2$output$XlsxDataStore$Lookup$$$_$apply$$anonfun$3(String key$1) {
        return key$1;
    }
}

