/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output.jdbc;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class PreparedStatementUtil {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PreparedStatementUtil.class);

    public static int getSQLType(DataType dataType) {
        switch (dataType.getTypeId()) {
            case 3: {
                return 16;
            }
            case 17: {
                return -2;
            }
            case 4: {
                return 91;
            }
            case 18: {
                return 3;
            }
            case 6: {
                return 8;
            }
            case 8: {
                return -5;
            }
            case 2: {
                return 12;
            }
            case 12: {
                return 92;
            }
            case 13: {
                return 93;
            }
            case 0: {
                return 12;
            }
        }
        return 12;
    }

    public static void update(PreparedStatement preparedStatement, int n, DataType dataType, Object object) throws SQLException {
        int n2 = n + 1;
        if (object == null) {
            preparedStatement.setNull(n2, PreparedStatementUtil.getSQLType(dataType));
            return;
        }
        try {
            switch (dataType.getTypeId()) {
                case 2: {
                    preparedStatement.setString(n2, (String)object);
                    break;
                }
                case 8: {
                    preparedStatement.setLong(n2, ((Number)object).longValue());
                    break;
                }
                case 6: {
                    preparedStatement.setDouble(n2, ((Number)object).doubleValue());
                    break;
                }
                case 3: {
                    preparedStatement.setBoolean(n2, (Boolean)object);
                    break;
                }
                case 18: {
                    preparedStatement.setBigDecimal(n2, (BigDecimal)object);
                    break;
                }
                case 4: {
                    Date date = (Date)object;
                    java.sql.Date date2 = new java.sql.Date(date.getTime());
                    preparedStatement.setDate(n2, date2);
                    break;
                }
                case 12: {
                    Date date = (Date)object;
                    Time time = new Time(date.getTime());
                    preparedStatement.setTime(n2, time);
                    break;
                }
                case 13: {
                    Date date = (Date)object;
                    Timestamp timestamp = new Timestamp(date.getTime());
                    preparedStatement.setTimestamp(n2, timestamp);
                    break;
                }
                case 17: {
                    if (object instanceof byte[]) {
                        byte[] byArray = (byte[])object;
                        preparedStatement.setBinaryStream(n2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                        break;
                    }
                    m_Log.warn((Object)("Unsupported byte array data type: " + object.getClass()));
                    break;
                }
                case 0: {
                    preparedStatement.setString(n2, String.valueOf(object));
                    break;
                }
                default: {
                    m_Log.error((Object)("Unknown data type: " + dataType.getTypeName()));
                    break;
                }
            }
        }
        catch (ClassCastException classCastException) {
            m_Log.error((Object)("ClassCastException: data \"" + object + "\" is not supported as a " + dataType.getTypeName()), (Throwable)classCastException);
            preparedStatement.setNull(n2, PreparedStatementUtil.getSQLType(dataType));
        }
    }
}

