/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output.sql;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.output.sql.Dialect;
import com.elixirtech.data2.output.sql.ISQLBuilder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BasicSQLBuilder
implements ISQLBuilder {
    private Dialect m_Dialect;
    private String m_TableName;
    private DataSchema m_Schema;
    private String m_IdentifierQuote;
    private String m_CatalogSeparator;
    private List<String> m_PrimaryKeys;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(BasicSQLBuilder.class);

    public static ISQLBuilder getBuilder(Connection connection, String string, String string2, String string3, DataSchema dataSchema) {
        Dialect dialect;
        Object object;
        if (StringUtil.notEmpty(string2) && (object = Dialect.getInstance(string2)) != null) {
            return new BasicSQLBuilder(connection, (Dialect)object, string3, dataSchema);
        }
        object = Dialect.getDriverDialect(string);
        if (StringUtil.isEmpty((String)object)) {
            object = Dialect.getDefaultDialect();
        }
        if ((dialect = Dialect.getInstance((String)object)) != null) {
            return new BasicSQLBuilder(connection, dialect, string3, dataSchema);
        }
        throw new RuntimeException("No dialect found for driver=\"" + string + "\" and dialect=\"" + string2 + "\"");
    }

    protected BasicSQLBuilder(Connection connection, Dialect dialect, String string, DataSchema dataSchema) {
        assert (dialect != null);
        this.m_Dialect = dialect;
        this.m_TableName = string;
        this.m_Schema = dataSchema;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.m_IdentifierQuote = databaseMetaData.getIdentifierQuoteString();
            this.m_CatalogSeparator = databaseMetaData.getCatalogSeparator();
            try {
                this.m_PrimaryKeys = this.getPrimaryKeys(databaseMetaData);
            }
            catch (SQLException sQLException) {
                m_Log.info((Object)("unable to read primary keys of table " + string));
                this.m_PrimaryKeys = new ArrayList<String>();
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Unable to query metadata", sQLException);
        }
    }

    @Override
    public List<String> getPrimaryKeys() {
        return this.m_PrimaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getPrimaryKeys(DatabaseMetaData databaseMetaData) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray = this.splitSchemaName(this.m_TableName);
            try (ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, stringArray[0], stringArray[1]);){
                if (resultSet == null) {
                    List<String> list = null;
                    return list;
                }
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("COLUMN_NAME"));
                }
                return arrayList;
            }
        }
        catch (Throwable throwable) {
            m_Log.warn((Object)("Can't read primary keys for " + this.m_TableName + " : " + throwable), throwable);
        }
        return arrayList;
    }

    @Override
    public Dialect getDialect() {
        return this.m_Dialect;
    }

    @Override
    public int getBatchSize() {
        String string = this.m_Dialect.getAttribute("batchSize");
        if (StringUtil.notEmpty(string)) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.warn((Object)("Can't convert batch size to int: \"" + string + "\""));
            }
        }
        return 0;
    }

    @Override
    public String createString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE ");
        String string = this.m_Dialect.getAttribute("tableOptions");
        if (StringUtil.notEmpty(string)) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
        stringBuilder.append("TABLE ");
        stringBuilder.append(this.sqlName(this.m_TableName));
        stringBuilder.append("(");
        int n = this.m_Schema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.sqlName(this.m_Schema.getColumnName(i)));
            stringBuilder.append(" ");
            stringBuilder.append(this.m_Dialect.getTypeName(this.m_Schema.getColumnType(i)));
            if (i >= n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String insertString() {
        int n;
        int n2 = this.m_Schema.getColumnCount();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ");
        stringBuilder.append(this.sqlName(this.m_TableName));
        stringBuilder.append(" (");
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(this.sqlName(this.m_Schema.getColumnName(n)));
            if (n >= n2 - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(") VALUES (");
        for (n = 0; n < n2; ++n) {
            stringBuilder.append("?");
            if (n >= n2 - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String existsString() {
        if (this.m_PrimaryKeys.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT COUNT(*) FROM ");
        stringBuilder.append(this.sqlName(this.m_TableName));
        stringBuilder.append(" WHERE ");
        int n = this.m_PrimaryKeys.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.m_PrimaryKeys.get(i));
            stringBuilder.append("=?");
            if (i >= this.m_PrimaryKeys.size() - 1) continue;
            stringBuilder.append(" AND ");
        }
        return stringBuilder.toString();
    }

    @Override
    public String updateString() {
        int n;
        if (this.m_PrimaryKeys.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.m_Schema.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            String string = this.m_Schema.getColumnName(i);
            if (this.m_PrimaryKeys.contains(string)) continue;
            arrayList.add(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ");
        stringBuilder.append(this.sqlName(this.m_TableName));
        stringBuilder.append(" SET ");
        int n3 = arrayList.size();
        for (n = 0; n < n3; ++n) {
            stringBuilder.append((String)arrayList.get(n));
            stringBuilder.append("=?");
            if (n >= arrayList.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(" WHERE ");
        n = this.m_PrimaryKeys.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.m_PrimaryKeys.get(i));
            stringBuilder.append("=?");
            if (i >= this.m_PrimaryKeys.size() - 1) continue;
            stringBuilder.append(" AND ");
        }
        return stringBuilder.toString();
    }

    @Override
    public String deleteString() {
        return "DELETE FROM " + this.sqlName(this.m_TableName);
    }

    @Override
    public String dropString() {
        return "DROP TABLE " + this.sqlName(this.m_TableName);
    }

    public String sqlName(String string) {
        if (string.startsWith(this.m_IdentifierQuote)) {
            return string;
        }
        if (StringUtil.notEmpty(this.m_CatalogSeparator) && string.indexOf(this.m_CatalogSeparator) > 0) {
            String[] stringArray = StringUtil.arrayOfSubstrings(string, this.m_CatalogSeparator.charAt(0));
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(this.m_CatalogSeparator);
                }
                stringBuilder.append(this.m_IdentifierQuote);
                stringBuilder.append(stringArray[i]);
                stringBuilder.append(this.m_IdentifierQuote);
            }
            return stringBuilder.toString();
        }
        return this.m_IdentifierQuote + string + this.m_IdentifierQuote;
    }

    protected String[] splitSchemaName(String string) {
        if (StringUtil.notEmpty(this.m_CatalogSeparator) && string.indexOf(this.m_CatalogSeparator) > 0) {
            String[] stringArray = StringUtil.arrayOfSubstrings(string, this.m_CatalogSeparator.charAt(0));
            return new String[]{this.strip(stringArray[0]), this.strip(stringArray[1])};
        }
        return new String[]{null, this.strip(string)};
    }

    private String strip(String string) {
        if ((string = string.trim()).startsWith(this.m_IdentifierQuote) && string.endsWith(this.m_IdentifierQuote)) {
            int n = this.m_IdentifierQuote.length();
            if (string.length() >= 2 * n) {
                string = string.substring(n, string.length() - 2 * n);
            }
        }
        return string;
    }
}

