/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.types;

import com.elixirtech.data2.DataType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public class ByteArrayDataType
extends DataType {
    public static final byte[] EMPTY = new byte[0];

    @Override
    public int getTypeId() {
        return 17;
    }

    @Override
    public String getTypeName() {
        return "ByteArray";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public Object defaultValue() {
        return EMPTY;
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        byte[] byArray = (byte[])object;
        byte[] byArray2 = (byte[])object2;
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            if (byArray[i] < byArray2[i]) {
                return -1;
            }
            if (byArray[i] <= byArray2[i]) continue;
            return 1;
        }
        if (byArray.length == byArray2.length) {
            return 0;
        }
        return byArray.length > n ? 1 : -1;
    }

    public byte[] narrow(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return String.valueOf(object).getBytes(Charset.forName("UTF-8"));
    }

    @Override
    public int writeLength(Object object) {
        if (object == null) {
            return 1;
        }
        return 5 + ((byte[])object).length;
    }

    @Override
    public void write(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null) {
            dataOutputStream.writeByte(0);
        } else {
            byte[] byArray = (byte[])object;
            dataOutputStream.writeByte(17);
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    @Override
    public Object read(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        if (by != 17) {
            throw new IOException("ByteArray tag expected, got " + by);
        }
        int n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return byArray;
    }
}

