/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.xlsx;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.datasource.excel.RangeUtil;
import com.elixirtech.data2.xlsx.Cell;
import com.elixirtech.data2.xlsx.Style;
import com.elixirtech.data2.xlsx.Workbook;
import com.elixirtech.data2.xlsx.XLSXReader;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.opc.XMLPart;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class Sheet {
    public static int WARN_LIMIT = 10;
    private final Workbook m_Workbook;
    private final String m_Name;
    private final XMLPart m_Part;
    private final List<Cell[]> m_Rows = new ArrayList<Cell[]>();
    private int m_WarnCount = 0;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Sheet.class);

    public Sheet(Workbook workbook, String string, XMLPart xMLPart) {
        this.m_Workbook = workbook;
        this.m_Name = string;
        this.m_Part = xMLPart;
        this.buildCells();
    }

    public String getName() {
        return this.m_Name;
    }

    public Cell[] getRow(int n) {
        return this.m_Rows.get(n);
    }

    public int getRowCount() {
        return this.m_Rows.size();
    }

    protected void buildCells() {
        try {
            Document document = this.m_Part.getDocument();
            Element element = document.getRootElement();
            if (!element.getName().equals("worksheet")) {
                throw new IllegalStateException("Document is not a worksheet: " + element.getName());
            }
            Element element2 = element.getChild("sheetData", XLSXReader.NS);
            for (Element element3 : element2.getChildren("row", XLSXReader.NS)) {
                int n = Integer.parseInt(element3.getAttributeValue("r")) - 1;
                String string = element3.getAttributeValue("spans");
                if (string == null) continue;
                String string2 = string.trim().split(" ")[0];
                int n2 = string2.indexOf(58);
                int n3 = Integer.parseInt(string2.substring(n2 + 1));
                List<Element> list = element3.getChildren("c", XLSXReader.NS);
                Cell[] cellArray = new Cell[n3];
                for (Element element4 : list) {
                    String string3 = element4.getAttributeValue("r");
                    Cell cell = this.buildCell(element4);
                    Point point = RangeUtil.getCellIndex(string3);
                    cellArray[point.x] = cell;
                }
                if (this.isEmpty(cellArray)) continue;
                while (this.m_Rows.size() < n) {
                    this.m_Rows.add(Cell.EMPTY_ROW);
                }
                this.m_Rows.add(cellArray);
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (this.m_WarnCount < WARN_LIMIT) {
                m_Log.warn((Object)("Sheet " + this.m_Name + ": Error reading cells: " + numberFormatException), (Throwable)numberFormatException);
                ++this.m_WarnCount;
            }
            throw numberFormatException;
        }
    }

    private boolean isEmpty(Cell[] cellArray) {
        for (int i = 0; i < cellArray.length; ++i) {
            if (cellArray[i] == null) continue;
            return false;
        }
        return true;
    }

    public Cell buildCell(Element element) {
        String string = element.getAttributeValue("t");
        if ("s".equals(string)) {
            Element element2 = element.getChild("v", XLSXReader.NS);
            int n = Integer.parseInt(element2.getText());
            return new Cell.TextCell(this.m_Workbook.getSharedString(n));
        }
        if ("inlineStr".equals(string)) {
            Element element3 = element.getChild("is", XLSXReader.NS);
            return new Cell.TextCell(element3.getValue());
        }
        if ("b".equals(string)) {
            Element element4 = element.getChild("v", XLSXReader.NS);
            return new Cell.BooleanCell(element4.getText());
        }
        if ("e".equals(string)) {
            if (this.m_WarnCount < WARN_LIMIT) {
                m_Log.warn((Object)("Sheet " + this.m_Name + ": has an error cell at " + element.getAttributeValue("r")));
                ++this.m_WarnCount;
            }
            return null;
        }
        Element element5 = element.getChild("v", XLSXReader.NS);
        if (element5 != null) {
            String string2 = element5.getText();
            if (string2.startsWith("#")) {
                if (this.m_WarnCount < WARN_LIMIT) {
                    m_Log.warn((Object)("Sheet " + this.m_Name + ": type " + string + " Unexpected numeric value: " + string2));
                    ++this.m_WarnCount;
                }
                return null;
            }
            String string3 = element.getAttributeValue("s");
            if (StringUtil.notEmpty(string3)) {
                int n = Integer.parseInt(string3);
                Style style = this.m_Workbook.getStyle(n);
                switch (style.getFormatType()) {
                    case 2: {
                        return new Cell.DateCell(this.m_Workbook, string2);
                    }
                    case 3: {
                        return new Cell.TimeCell(string2);
                    }
                    case 4: {
                        return new Cell.TimestampCell(this.m_Workbook, string2);
                    }
                }
                return new Cell.NumberCell(string2);
            }
            return new Cell.NumberCell(string2);
        }
        return null;
    }
}

