/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.DimensionNode;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.InitialText;
import com.elixirtech.ensemble.canvas.MeasureNode;
import com.elixirtech.ensemble.canvas.SchemaNode;
import com.elixirtech.ensemble.canvas.SortNode;
import java.util.List;

public class CubeGO
extends InOutGO {
    private DataSchema m_CachedSchema;
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CubeGO.class);

    public CubeGO() {
        this.m_Ins.add(new InOutGO.In(this, "data", 0.5));
        this.m_Outs.add(new InOutGO.Out(this, "data", 0.5));
        this.m_Text = InitialText.CubeGO();
    }

    public DataSchema getDataSchema() {
        InOutGO inOutGO = this.getInput();
        if (inOutGO != null) {
            return inOutGO.getSchema();
        }
        return null;
    }

    public InOutGO getInput() {
        InOutGO.In in = this.getIn("data");
        List<DataFlowGO> list = this.getFlowGOs(in);
        if (list.size() == 1) {
            DataFlowGO dataFlowGO = list.get(0);
            return (InOutGO)dataFlowGO.getStartGO();
        }
        return null;
    }

    public DataSchema getCachedSchema() {
        if (this.m_CachedSchema == null) {
            this.extractCachedSchema();
        }
        return this.m_CachedSchema;
    }

    @Override
    public DataSchema getSchema() {
        if (this.getDataSchema() != null) {
            if (this.m_CachedSchema == null) {
                this.extractCachedSchema();
            }
            return this.m_CachedSchema;
        }
        return null;
    }

    public void setCachedSchema(DataSchema dataSchema) {
        SchemaNode schemaNode = (SchemaNode)this.getNode(SchemaNode.class);
        if (schemaNode != null) {
            schemaNode.disconnect();
        }
        if (dataSchema != null) {
            schemaNode = new SchemaNode(dataSchema);
            this.connectTo(schemaNode, RelType.Owns);
        }
        this.m_CachedSchema = dataSchema;
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
        InOutGO.In in = this.getIn("data");
        List<DataFlowGO> list = this.getFlowGOs(in);
        if (list.size() == 1) {
            DataFlowGO dataFlowGO = list.get(0);
            dataFlowGO.buildParameters(argumentMap);
        }
    }

    public void removeAllDimensions() {
        DimensionHolder dimensionHolder = (DimensionHolder)this.getNode(DimensionHolder.class);
        if (dimensionHolder != null) {
            dimensionHolder.disconnect();
        }
    }

    public void addDimension(String string, SortNode[] sortNodeArray) {
        DimensionHolder dimensionHolder = (DimensionHolder)this.getNode(DimensionHolder.class);
        if (dimensionHolder == null) {
            dimensionHolder = new DimensionHolder();
            this.connectTo(dimensionHolder, RelType.Owns);
        }
        DimensionNode dimensionNode = new DimensionNode(string, sortNodeArray);
        dimensionHolder.connectTo(dimensionNode, RelType.Owns);
    }

    public int getDimensionCount() {
        DimensionHolder dimensionHolder = (DimensionHolder)this.getNode(DimensionHolder.class);
        if (dimensionHolder == null) {
            return 0;
        }
        RelCol relCol = dimensionHolder.getOutRelCol(RelType.Owns);
        return relCol.getCount();
    }

    public DimensionNode getDimension(int n) {
        DimensionHolder dimensionHolder = (DimensionHolder)this.getNode(DimensionHolder.class);
        return (DimensionNode)dimensionHolder.getChildArray()[n];
    }

    public void removeAllMeasures() {
        MeasureHolder measureHolder = (MeasureHolder)this.getNode(MeasureHolder.class);
        if (measureHolder != null) {
            measureHolder.disconnect();
        }
    }

    public void addMeasure(String string, String string2, String string3) {
        MeasureHolder measureHolder = (MeasureHolder)this.getNode(MeasureHolder.class);
        if (measureHolder == null) {
            measureHolder = new MeasureHolder();
            this.connectTo(measureHolder, RelType.Owns);
        }
        MeasureNode measureNode = new MeasureNode(string, string2, string3);
        measureHolder.connectTo(measureNode, RelType.Owns);
    }

    public int getMeasureCount() {
        MeasureHolder measureHolder = (MeasureHolder)this.getNode(MeasureHolder.class);
        if (measureHolder == null) {
            return 0;
        }
        RelCol relCol = measureHolder.getOutRelCol(RelType.Owns);
        return relCol.getCount();
    }

    public MeasureNode getMeasure(int n) {
        MeasureHolder measureHolder = (MeasureHolder)this.getNode(MeasureHolder.class);
        return (MeasureNode)measureHolder.getChildArray()[n];
    }

    public boolean isCollapseRows() {
        return this.isUserProperty("Cube_CollapseRows");
    }

    public void setCollapseRows(boolean bl) {
        this.setUserProperty("Cube_CollapseRows", bl);
    }

    public boolean isCollapseColumns() {
        return this.isUserProperty("Cube_CollapseColumns");
    }

    public void setCollapseColumns(boolean bl) {
        this.setUserProperty("Cube_CollapseColumns", bl);
    }

    public boolean isKeepRowTotals() {
        return this.isUserProperty("Cube_KeepRowTotals");
    }

    public void setKeepRowTotals(boolean bl) {
        this.setUserProperty("Cube_KeepRowTotals", bl);
    }

    public boolean isKeepColumnTotals() {
        return this.isUserProperty("Cube_KeepColumnTotals");
    }

    public void setKeepColumnTotals(boolean bl) {
        this.setUserProperty("Cube_KeepColumnTotals", bl);
    }

    public boolean isShowColumnTotalsAfterDetails() {
        return this.isUserProperty("Cube_ShowColumnTotalsAfterDetails");
    }

    public void setShowColumnTotalsAfterDetails(boolean bl) {
        this.setUserProperty("Cube_ShowColumnTotalsAfterDetails", bl);
    }

    public boolean isShowRowTotalsAfterDetails() {
        return this.isUserProperty("Cube_ShowRowTotalsAfterDetails");
    }

    public void setShowRowTotalsAfterDetails(boolean bl) {
        this.setUserProperty("Cube_ShowRowTotalsAfterDetails", bl);
    }

    public void setRowTitle(String string) {
        this.setUserProperty("Cube_RowTitle", string);
    }

    public void setColumnTitle(String string) {
        this.setUserProperty("Cube_ColumnTitle", string);
    }

    public String getRowTitle() {
        return this.getUserProperty("Cube_RowTitle");
    }

    public String getColumnTitle() {
        return this.getUserProperty("Cube_ColumnTitle");
    }

    private void extractCachedSchema() {
        SchemaNode schemaNode = (SchemaNode)this.getNode(SchemaNode.class);
        if (schemaNode != null) {
            this.m_CachedSchema = schemaNode.getSchema();
        }
    }

    private Node getNode(Class<?> clazz) {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        for (Node node : relCol.getTargetElements()) {
            if (!node.getClass().equals(clazz)) continue;
            return node;
        }
        return null;
    }

    public static class DimensionHolder
    extends Node {
    }

    public static class MeasureHolder
    extends Node {
    }
}

