/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.graph.Relationship;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.grouping.GrouperFactory;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.InitialText;
import com.elixirtech.ensemble.canvas.SortNode;
import java.util.List;

public class SortGO
extends InOutGO {
    public SortGO() {
        this.m_Ins.add(new InOutGO.In("data", 0.5));
        this.m_Outs.add(new InOutGO.Out("data", 0.5));
        this.m_Text = InitialText.SortGO();
    }

    public DataSchema getBaseSchema() {
        InOutGO.In in = this.getIn("data");
        List<DataFlowGO> list = this.getFlowGOs(in);
        if (list.size() == 1) {
            DataFlowGO dataFlowGO = list.get(0);
            return ((InOutGO)dataFlowGO.getStartGO()).getSchema();
        }
        return null;
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
        Object object;
        InOutGO.In in = this.getIn("data");
        List<DataFlowGO> list = this.getFlowGOs(in);
        if (list.size() == 1) {
            object = list.get(0);
            ((DataFlowGO)object).buildParameters(argumentMap);
        }
        object = this.getOutRelCol(RelType.Owns);
        for (int i = 0; i < object.getCount(); ++i) {
            Relationship relationship = object.getItem(i);
            SortNode sortNode = (SortNode)relationship.getDestination();
            argumentMap.extractParameters(sortNode.getGroupData());
        }
        argumentMap.extractParameters(this.getExtractValue());
    }

    public String getExtractValue() {
        return this.getUserProperty("Sort_Extract");
    }

    public void setExtractValue(String string) {
        this.setUserProperty("Sort_Extract", string);
    }

    public void removeAllSorts() {
        this.removeOutRelationships(RelType.Owns);
    }

    public void addSort(SortNode sortNode) {
        this.connectTo(sortNode, RelType.Owns);
    }

    public int getSortCount() {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        return relCol.getCount();
    }

    public SortNode getSort(int n) {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        Relationship relationship = relCol.getItem(n);
        return (SortNode)relationship.getDestination();
    }

    @Override
    public DataSchema getSchema() {
        DataSchema dataSchema = this.getBaseSchema();
        if (dataSchema == null) {
            return null;
        }
        SchemaBuilder schemaBuilder = new SchemaBuilder(dataSchema);
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        int n = relCol.getCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            Relationship relationship = relCol.getItem(i);
            SortNode sortNode = (SortNode)relationship.getDestination();
            String string = sortNode.getDerivedField();
            if (!StringUtil.notEmpty(string) || (n2 = dataSchema.getColumnIndex(sortNode.getName())) < 0) continue;
            DataType dataType = dataSchema.getColumnType(n2);
            DataType dataType2 = GrouperFactory.getGroupType(sortNode.getGroupOn(), dataType);
            schemaBuilder.add(string, dataType2, new DataAttributes());
        }
        return schemaBuilder.getSchema();
    }
}

