/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.data2.grouping.GroupDefinition;
import java.util.Map;

public class SortNode
extends Node {
    public static final String ASCENDING = "Ascending";
    public static final String ASCENDING_LEXICOGRAPHIC = "Ascending-Lexicographic";
    public static final String DESCENDING = "Descending";
    public static final String DESCENDING_LEXICOGRAPHIC = "Descending-Lexicographic";
    public static final String NONE = "None";
    private String m_Name;
    private String m_SortOrder;
    private String m_GroupOn;
    private String m_GroupData;
    private String m_DerivedField;
    private String m_TotalTitle;
    private boolean m_ShowTotals = true;

    public SortNode() {
    }

    public SortNode(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        this.m_Name = string;
        this.m_SortOrder = string2;
        this.m_GroupOn = string3;
        this.m_GroupData = string4;
        this.m_DerivedField = string5;
        this.m_ShowTotals = bl;
        this.m_TotalTitle = string6;
    }

    public SortNode(SortNode sortNode) {
        this.m_Name = sortNode.m_Name;
        this.m_SortOrder = sortNode.m_SortOrder;
        this.m_GroupOn = sortNode.m_GroupOn;
        this.m_GroupData = sortNode.m_GroupData;
        this.m_DerivedField = sortNode.m_DerivedField;
        this.m_TotalTitle = sortNode.m_TotalTitle;
        this.m_ShowTotals = sortNode.m_ShowTotals;
    }

    public SortNode(GroupDefinition groupDefinition) {
        this.m_Name = groupDefinition.getName();
        this.m_SortOrder = groupDefinition.getSortOrder();
        this.m_GroupOn = groupDefinition.getGroupOn();
        this.m_GroupData = groupDefinition.getGroupData();
        this.m_DerivedField = groupDefinition.getDerivedFieldName();
        this.m_ShowTotals = groupDefinition.isShowTotals();
        this.m_TotalTitle = "";
    }

    public GroupDefinition getGroupDefinition() {
        return new GroupDefinition(this.m_Name, this.m_SortOrder, this.m_GroupOn, this.m_GroupData, this.m_DerivedField, this.m_ShowTotals);
    }

    public String getName() {
        return this.m_Name;
    }

    public String getSortOrder() {
        return this.m_SortOrder;
    }

    public String getGroupOn() {
        return this.m_GroupOn;
    }

    public String getGroupData() {
        return this.m_GroupData;
    }

    public String getDerivedField() {
        return this.m_DerivedField;
    }

    public String getTotalTitle() {
        return this.m_TotalTitle;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public void setSortOrder(String string) {
        this.m_SortOrder = string;
    }

    public void setGroupOn(String string) {
        this.m_GroupOn = string;
    }

    public void setGroupData(String string) {
        this.m_GroupData = string;
    }

    public void setDerivedField(String string) {
        this.m_DerivedField = string;
    }

    public void setTotalTitle(String string) {
        this.m_TotalTitle = string;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        map.put("Name", this.m_Name);
        map.put("SortOrder", this.m_SortOrder);
        map.put("GroupOn", this.m_GroupOn);
        map.put("GroupData", this.m_GroupData);
        map.put("DerivedField", this.m_DerivedField);
        map.put("TotalTitle", this.m_TotalTitle);
        map.put("ShowTotals", this.m_ShowTotals ? "Yes" : "No");
        return map;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equals("Name")) {
            this.m_Name = string2;
        } else if (string.equals("SortOrder")) {
            this.m_SortOrder = string2;
        } else if (string.equals("GroupOn")) {
            this.m_GroupOn = string2;
        } else if (string.equals("GroupData")) {
            this.m_GroupData = string2;
        } else if (string.equals("DerivedField")) {
            this.m_DerivedField = string2;
        } else if (string.equals("ShowTotals")) {
            this.m_ShowTotals = "Yes".equals(string2);
        } else if (string.equals("TotalTitle")) {
            this.m_TotalTitle = string2;
        } else {
            super.setProperty(string, string2);
        }
    }

    public boolean isShowTotals() {
        return this.m_ShowTotals;
    }

    public void setShowTotals(boolean bl) {
        this.m_ShowTotals = bl;
    }
}

