/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.arch.ByteUtil;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ICachedFile;
import com.elixirtech.arch.RemoteMarker;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.RawDataSource;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.datasource.composite.CompositeScope;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.DataStoreRegistry;
import com.elixirtech.data2.output.IDataStore;
import com.elixirtech.ensemble.ds.RecordCounter;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.mozilla.javascript.Scriptable;

public class DSUtil {
    private static final ThreadLocal<Set<String>> CURRENTLY_LOADING = new ThreadLocal();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DSUtil.class);

    public static boolean isRemote() {
        return Elixir.get(RemoteMarker.class) != null;
    }

    public static void updateSecurityPath(Element element, String string) {
        Element element2 = element.getChild("security", DataSourceDefinition.NS_DATASOURCE);
        if (element2 != null) {
            assert (string != null);
            String string2 = element2.getAttributeValue("encrypted");
            if ("Yes".equals(string2)) {
                String string3 = element2.getAttributeValue("name");
                if (StringUtil.isEmpty(string3)) {
                    element2.setAttribute("name", string);
                }
            } else {
                element2.setAttribute("name", "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDataSource load(RMLFileObject rMLFileObject) throws IOException {
        String string = rMLFileObject.getPathString();
        Set<String> set = CURRENTLY_LOADING.get();
        if (set == null) {
            set = new HashSet<String>();
            CURRENTLY_LOADING.set(set);
        } else if (set.contains(string)) {
            throw new IOException("Recursive load error in: " + string);
        }
        set.add(string);
        try {
            IDataSource iDataSource = DSUtil.doLoad(rMLFileObject);
            return iDataSource;
        }
        finally {
            set.remove(string);
        }
    }

    public static List<String> getDataStores(RMLFileObject rMLFileObject) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        IDataSource iDataSource = DSUtil.load(rMLFileObject);
        if (iDataSource instanceof CompositeDataSource) {
            Collection<DataStore> collection = ((CompositeDataSource)iDataSource).getDataStores();
            for (DataStore dataStore : collection) {
                arrayList.add(dataStore.getName());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDatasourceType(RMLFileObject rMLFileObject) throws IOException {
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            InputStream inputStream = rMLFileObject.getInputStream();
            Document document = null;
            try {
                document = sAXBuilder.build(inputStream);
            }
            finally {
                FileUtil.close(inputStream);
            }
            assert (document != null);
            document = DSUtil.decryptIfNecessary(sAXBuilder, document);
            Element element = document.getRootElement();
            return element.getAttributeValue("type");
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't load " + rMLFileObject.getPath() + " : " + exception), (Throwable)exception);
            throw new IOException("Unable to load " + rMLFileObject.getPath() + " : " + exception);
        }
    }

    public static List<Parameter> getParameters(RMLFileObject rMLFileObject) throws IOException {
        return DSUtil.getParameters(rMLFileObject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Parameter> getParameters(RMLFileObject rMLFileObject, boolean bl) throws IOException {
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            InputStream inputStream = rMLFileObject.getInputStream();
            Document document = null;
            try {
                document = sAXBuilder.build(inputStream);
            }
            finally {
                FileUtil.close(inputStream);
            }
            assert (document != null);
            document = DSUtil.decryptIfNecessary(sAXBuilder, document);
            Element element = document.getRootElement();
            Element element2 = element.getChild("parameter-cache", Data2Constants.NS_DATASOURCE);
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            if (element2 != null) {
                List<Element> list = element2.getChildren("parameter", Data2Constants.NS_DATASOURCE);
                for (Element element3 : list) {
                    arrayList.add(DSUtil.buildParameter(element3));
                }
            } else {
                m_Log.warn((Object)("Unable to cache parameters for " + rMLFileObject.getPath()));
            }
            return arrayList;
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't load " + rMLFileObject.getName() + " : " + exception), (Throwable)exception);
            throw new IOException("Unable to load " + rMLFileObject.getName() + " : " + exception);
        }
    }

    private static Parameter buildParameter(Element element) {
        String string = element.getAttributeValue("name");
        String string2 = element.getAttributeValue("type");
        String string3 = element.getAttributeValue("default-value");
        List<Element> list = element.getChildren("dependency", Data2Constants.NS_DATASOURCE);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = list.get(i).getAttributeValue("on");
        }
        return new Parameter(string, string2, string3, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDataSource doLoad(RMLFileObject rMLFileObject) throws IOException {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        m_Log.debug((Object)("Reading DataSource from file: " + rMLFileObject.getName()));
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            InputStream inputStream = rMLFileObject.getInputStream();
            Document document = null;
            try {
                document = sAXBuilder.build(inputStream);
            }
            finally {
                FileUtil.close(inputStream);
            }
            assert (document != null);
            IDataSource iDataSource = DataSourceDefinition.load(dataSourceManager, (document = DSUtil.decryptIfNecessary(sAXBuilder, document)).getRootElement());
            if (iDataSource == null) {
                m_Log.error((Object)("Can't load " + rMLFileObject.getName()));
                throw new IOException("Unable to load " + rMLFileObject.getName());
            }
            DSUtil.postprocessLoad(rMLFileObject, iDataSource);
            if (DSUtil.needsClone(iDataSource)) {
                iDataSource = DataSourceDefinition.clone(dataSourceManager, iDataSource);
            }
            return iDataSource;
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't load " + rMLFileObject.getName() + " : " + exception), (Throwable)exception);
            throw new IOException("Unable to load " + rMLFileObject.getName() + " : " + exception);
        }
    }

    private static void postprocessLoad(RMLFileObject rMLFileObject, IDataSource iDataSource) {
        String string = rMLFileObject.getName();
        if (string.endsWith(".ds")) {
            string = string.substring(0, string.length() - 3);
        }
        DSUtil.setName(iDataSource, string);
        DSUtil.setFileObject(iDataSource, rMLFileObject);
    }

    private static boolean needsClone(IDataSource iDataSource) {
        if (iDataSource instanceof CompositeDataSource) {
            return false;
        }
        return !(iDataSource instanceof RawDataSource);
    }

    private static Document decryptIfNecessary(SAXBuilder sAXBuilder, Document document) throws IOException, JDOMException {
        Element element = document.getRootElement();
        if (element.getName().equals("encrypted-datasource") && element.getNamespace().equals(Data2Constants.NS_DATASOURCE)) {
            m_Log.info((Object)"loading encrypted datasource");
            String string = element.getAttributeValue("version");
            if (!"1".equals(string)) {
                throw new IOException("Incorrect encryption version: " + string);
            }
            String string2 = element.getText();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ByteUtil.decodeBase64(string2));
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            Document document2 = sAXBuilder.build(gZIPInputStream);
            gZIPInputStream.close();
            return document2;
        }
        return document;
    }

    public static IDataSource load(InputStream inputStream) throws IOException {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(inputStream);
            document = DSUtil.decryptIfNecessary(sAXBuilder, document);
            IDataSource iDataSource = DataSourceDefinition.load(dataSourceManager, document.getRootElement());
            return iDataSource;
        }
        catch (JDOMException jDOMException) {
            m_Log.error((Object)("Can't load from input stream: " + jDOMException), (Throwable)jDOMException);
            throw new IOException("Unable to load from input stream: " + jDOMException);
        }
    }

    public static void setName(IDataSource iDataSource, String string) {
        if (!iDataSource.getName().equals(string)) {
            Class<?> clazz = iDataSource.getClass();
            try {
                Method method = clazz.getMethod("setName", String.class);
                method.invoke((Object)iDataSource, string);
            }
            catch (Exception exception) {
                m_Log.error((Object)("Unable to set name of " + iDataSource), (Throwable)exception);
            }
        }
    }

    public static void setFileObject(IDataSource iDataSource, RMLFileObject rMLFileObject) {
        ICachedFile iCachedFile = iDataSource.getAdapter(ICachedFile.class);
        if (iCachedFile != null) {
            iCachedFile.setFileObject(rMLFileObject);
        }
    }

    public static void close(RMLFileObject rMLFileObject) {
    }

    public static int generate(CompositeDataSource compositeDataSource, PushContext pushContext, DataStore dataStore) throws DataException {
        DataListener2 dataListener2;
        DataListener2 dataListener22 = DataStoreRegistry.getDataListener(pushContext, dataStore);
        if (dataListener22 instanceof IDataStore) {
            dataListener2 = (IDataStore)dataListener22;
            dataListener2.setContext(pushContext);
            dataListener2.setName(dataStore.getName());
        }
        if (dataListener22 != null) {
            dataListener2 = new RecordCounter(dataListener22);
            JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
            javaScriptEngine.pushScope((Scriptable)new CompositeScope(compositeDataSource));
            compositeDataSource.initScript(pushContext);
            dataStore.getDataSource().pushTo(pushContext, dataListener2);
            javaScriptEngine.popScope();
            return ((RecordCounter)dataListener2).getCount();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> buildMap(PushContext pushContext, String string, DataStore dataStore) {
        String string2 = "Custom Java DataStore".equals(string) ? dataStore.getProperty("Java_ClassName") : string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string3 = DataStoreRegistry.getPrefix(string2);
        if (StringUtil.notEmpty(string3)) {
            Map<String, String> map = dataStore.getProperties();
            for (String string4 : map.keySet()) {
                void var8_12;
                if (!string4.startsWith(string3) || string4.equals("Java_ClassName")) continue;
                String string5 = map.get(string4);
                String string6 = string4.substring(string3.length());
                if (string6.length() <= 0) continue;
                boolean bl = true;
                if (string6.length() > 1) {
                    boolean bl2 = bl = !Character.isUpperCase(string6.charAt(1));
                }
                if (bl) {
                    String string7 = Character.toLowerCase(string6.charAt(0)) + string6.substring(1);
                }
                hashMap.put((String)var8_12, string5);
            }
        }
        if (!hashMap.containsKey("name")) {
            hashMap.put("name", dataStore.getName());
        }
        return hashMap;
    }

    public static IDataSource clone(IDataSource iDataSource) {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        Element element = DataSourceDefinition.save(iDataSource);
        return DataSourceDefinition.load(dataSourceManager, element);
    }
}

