/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.Color;
import com.elixirtech.glint.Eye;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Pen;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.PhysicalRenderer;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.util.VariableSubstitution;
import com.elixirtech.ui.StandardColor;
import java.awt.Point;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GlintRenderContext
extends PhysicalRenderContext
implements GraphicsCodes {
    protected IGlint m_Glint;
    protected boolean m_FlushGlint;
    protected IGlint.StringId m_TotalId;

    public GlintRenderContext(PhysicalRenderer physicalRenderer, int n, Page page, Eye eye, Map<String, Object> map) throws IOException {
        this(physicalRenderer, n, page, eye.newPage(), map);
        this.m_FlushGlint = true;
    }

    public GlintRenderContext(PhysicalRenderer physicalRenderer, int n, Page page, Eye eye, Map<String, Object> map, boolean bl) throws IOException {
        this(physicalRenderer, n, page, eye.newPage(), map, bl);
        this.m_FlushGlint = true;
    }

    public GlintRenderContext(PhysicalRenderer physicalRenderer, int n, Page page, IGlint iGlint, Map<String, Object> map) {
        this(physicalRenderer, n, page, iGlint, map, true);
    }

    public GlintRenderContext(PhysicalRenderer physicalRenderer, int n, Page page, IGlint iGlint, Map<String, Object> map, boolean bl) {
        super(physicalRenderer, n, page, map);
        PageSetup pageSetup = page.getPageSetup();
        this.m_Glint = iGlint;
        int n2 = pageSetup.getWidth();
        int n3 = pageSetup.getHeight();
        int n4 = "Portrait".equals(pageSetup.getOrientation()) ? 1 : 2;
        this.m_Glint.init(n2, n3, n4);
        if (bl) {
            this.m_Glint.drawRect(this.m_Glint.definePen(Pen.NONE), this.m_Glint.defineColor(Color.WHITE), 0, 0, n2, n3);
        }
        this.m_Glint.offsetOrigin(-this.m_HShift, 0);
    }

    public IGlint getGlint() {
        return this.m_Glint;
    }

    public Color lookupGlintColor(String string) {
        return Color.newInstance(StandardColor.lookup(string));
    }

    public void setTotalId(IGlint.StringId stringId) {
        this.m_TotalId = stringId;
        if (stringId != null) {
            this.buildVariableSubstitution();
        }
    }

    @Override
    public void dispose() {
        this.m_Glint.offsetOrigin(this.m_HShift, 0);
        if (this.m_FlushGlint) {
            this.m_Glint.flush();
        }
        super.dispose();
    }

    @Override
    public Point getOffset() {
        return new Point(this.m_Glint.getOriginX(), this.m_Glint.getOriginY());
    }

    @Override
    protected void buildVariableSubstitution() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.m_PageNumber = Integer.toString(this.m_Page.getPageNumber());
        int n = this.m_Page.getPageCount();
        if (n == 0 && this.m_TotalId != null) {
            int n2 = 57344 + this.m_TotalId.id;
            this.m_PageCount = new String(new char[]{(char)n2});
        } else {
            this.m_PageCount = Integer.toString(this.m_Page.getPageCount());
        }
        hashMap.put("#", this.m_PageNumber);
        hashMap.put("##", this.m_PageCount);
        hashMap.put("@", this.m_PageNumber + " of " + this.m_PageCount);
        this.m_VariableSubstitution = new VariableSubstitution(hashMap);
    }
}

