/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.Color;
import com.elixirtech.glint.ConstBytes;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GlintException;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.IResourceManager;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceManager
implements IResourceManager,
GraphicsCodes {
    private DataOutputStream m_Out;
    private final Map<String, IGlint.FontId> m_FontMap = new HashMap<String, IGlint.FontId>();
    private final Map<String, IGlint.ColorId> m_ColorMap = new HashMap<String, IGlint.ColorId>();
    private final Map<String, IGlint.ImageId> m_ImageMap = new HashMap<String, IGlint.ImageId>();
    private final Map<String, IGlint.PenId> m_PenMap = new HashMap<String, IGlint.PenId>();
    private final List<Font> m_FontList = new ArrayList<Font>();
    private final List<Color> m_ColorList = new ArrayList<Color>();
    private final List<Image> m_ImageList = new ArrayList<Image>();
    private final List<Pen> m_PenList = new ArrayList<Pen>();
    private final List<String> m_StringList = new ArrayList<String>();

    protected ResourceManager() {
        this.initConstants();
    }

    public ResourceManager(OutputStream outputStream) {
        this.m_Out = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        this.initConstants();
    }

    private void initConstants() {
        this.m_PenMap.put(this.getKey(Pen.NONE), new IGlint.PenId(0));
        this.m_PenList.add(Pen.NONE);
        this.m_ColorMap.put(this.getKey(Color.NONE), new IGlint.ColorId(0));
        this.m_ColorList.add(Color.NONE);
    }

    @Override
    public IGlint.FontId defineFont(Font font) {
        String string = this.getKey(font);
        IGlint.FontId fontId = this.m_FontMap.get(string);
        if (fontId == null) {
            try {
                int n = font.getType();
                if (n == 1) {
                    this.m_Out.write(128);
                    this.m_Out.writeUTF(font.getName());
                    this.m_Out.writeInt(font.getStyle());
                    this.m_Out.writeInt(font.getSize());
                } else if (n == 2) {
                    ConstBytes constBytes = ((Font.ByteFont)font).getBytes();
                    this.m_Out.write(129);
                    this.m_Out.writeUTF(font.getName());
                    this.m_Out.writeInt(font.getStyle());
                    this.m_Out.writeInt(font.getSize());
                    this.m_Out.writeInt(constBytes.length());
                    constBytes.write(this.m_Out);
                } else if (n == 3) {
                    this.m_Out.write(130);
                    Font font2 = ((Font.DerivedFont)font).getBase();
                    String string2 = this.getKey(font2);
                    IGlint.FontId fontId2 = this.m_FontMap.get(string2);
                    if (fontId2 == null) {
                        throw new GlintException("Undefined base font used for derivation");
                    }
                    this.m_Out.writeShort(fontId2.id);
                    this.m_Out.writeInt(font.getStyle());
                    this.m_Out.writeInt(font.getSize());
                }
            }
            catch (IOException iOException) {
                throw new GlintException("defineFont", iOException);
            }
            fontId = new IGlint.FontId(this.m_FontList.size());
            this.m_FontMap.put(string, fontId);
            this.m_FontList.add(font);
        }
        return fontId;
    }

    @Override
    public IGlint.ColorId defineColor(Color color) {
        String string = this.getKey(color);
        IGlint.ColorId colorId = this.m_ColorMap.get(string);
        if (colorId == null) {
            try {
                this.m_Out.write(132);
                this.m_Out.writeInt(color.getRGB());
            }
            catch (IOException iOException) {
                throw new GlintException("defineColor", iOException);
            }
            colorId = new IGlint.ColorId(this.m_ColorList.size());
            this.m_ColorMap.put(string, colorId);
            this.m_ColorList.add(color);
        }
        return colorId;
    }

    @Override
    public IGlint.ImageId defineImage(Image image) {
        String string = this.getKey(image);
        IGlint.ImageId imageId = this.m_ImageMap.get(string);
        if (imageId == null) {
            try {
                int n = image.getDataType();
                if (n == 1) {
                    int n2 = image.getWidth();
                    int n3 = image.getHeight();
                    this.m_Out.write(133);
                    this.m_Out.writeInt(n2);
                    this.m_Out.writeInt(n3);
                    int[] nArray = (int[])image.getData();
                    this.m_Out.writeInt(nArray.length);
                    for (int i = 0; i < nArray.length; ++i) {
                        this.m_Out.writeInt(nArray[i]);
                    }
                } else {
                    this.m_Out.write(134);
                    byte[] byArray = (byte[])image.getData();
                    this.m_Out.writeInt(byArray.length);
                    this.m_Out.write(byArray);
                }
            }
            catch (IOException iOException) {
                throw new GlintException("defineImage", iOException);
            }
            imageId = new IGlint.ImageId(this.m_ImageList.size());
            if (string != null) {
                this.m_ImageMap.put(string, imageId);
            }
            this.m_ImageList.add(image);
        }
        return imageId;
    }

    @Override
    public IGlint.PenId definePen(Pen pen) {
        String string = this.getKey(pen);
        IGlint.PenId penId = this.m_PenMap.get(string);
        if (penId == null) {
            try {
                IGlint.ColorId colorId = this.defineColor(pen.getColor());
                this.m_Out.write(135);
                this.m_Out.writeShort(colorId.id);
                this.m_Out.writeShort(pen.getWidth());
                this.m_Out.write(pen.getStyle());
            }
            catch (IOException iOException) {
                throw new GlintException("definePen", iOException);
            }
            penId = new IGlint.PenId(this.m_PenList.size());
            this.m_PenMap.put(string, penId);
            this.m_PenList.add(pen);
        }
        return penId;
    }

    @Override
    public Font getFont(IGlint.FontId fontId) {
        return this.m_FontList.get(fontId.id);
    }

    @Override
    public Color getColor(IGlint.ColorId colorId) {
        return this.m_ColorList.get(colorId.id);
    }

    @Override
    public Image getImage(IGlint.ImageId imageId) {
        return this.m_ImageList.get(imageId.id);
    }

    @Override
    public Pen getPen(IGlint.PenId penId) {
        return this.m_PenList.get(penId.id);
    }

    @Override
    public int getFontCount() {
        return this.m_FontList.size();
    }

    @Override
    public int getColorCount() {
        return this.m_ColorList.size();
    }

    @Override
    public int getImageCount() {
        return this.m_ImageList.size();
    }

    @Override
    public int getPenCount() {
        return this.m_PenList.size();
    }

    @Override
    public IGlint.StringId defineString() {
        IGlint.StringId stringId = new IGlint.StringId(this.m_StringList.size());
        this.m_StringList.add("");
        try {
            this.m_Out.write(136);
        }
        catch (IOException iOException) {
            throw new GlintException("setString", iOException);
        }
        return stringId;
    }

    @Override
    public void setString(IGlint.StringId stringId, String string) {
        this.m_StringList.set(stringId.id, string);
        try {
            this.m_Out.write(137);
            this.m_Out.writeShort(stringId.id);
            this.m_Out.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new GlintException("setString", iOException);
        }
    }

    @Override
    public String getString(IGlint.StringId stringId) {
        return this.m_StringList.get(stringId.id);
    }

    @Override
    public int getStringCount() {
        return this.m_StringList.size();
    }

    private String getKey(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getName());
        stringBuffer.append('|');
        stringBuffer.append(font.getSize());
        stringBuffer.append('|');
        stringBuffer.append(font.getStyle());
        return stringBuffer.toString();
    }

    private String getKey(Color color) {
        if (color == Color.NONE) {
            return "None";
        }
        return Integer.toString(color.getRGB());
    }

    private String getKey(Image image) {
        return image.getId();
    }

    private String getKey(Pen pen) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(pen.getColor().getRGB());
        stringBuffer.append('|');
        stringBuffer.append(pen.getWidth());
        stringBuffer.append('|');
        stringBuffer.append(pen.getStyle());
        return stringBuffer.toString();
    }
}

