/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.g2d;

import com.elixirtech.glint.Color;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import com.elixirtech.glint.g2d.GlintGraphics2D;
import com.elixirtech.glint.g2d.URLMap;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Glint2DContext
implements GraphicsCodes {
    public final Graphics2D g;
    private final URLMap m_URLMap = new URLMap();
    private final List<Color> m_Colors = new ArrayList<Color>();
    private final List<Font> m_Fonts = new ArrayList<Font>();
    private final List<Image> m_Images = new ArrayList<Image>();
    private final List<Pen> m_Pens = new ArrayList<Pen>();
    private final List<String> m_Strings = new ArrayList<String>();
    private final Map<Pen, Stroke> m_Strokes = new HashMap<Pen, Stroke>();
    private final Stack<URLMap.URLStruct> m_URLs = new Stack();
    private final Stack<Shape> m_ClipRects = new Stack();
    private URLMap.URLStruct m_CurrentURL;
    private java.awt.Color m_CurrentColor;
    private boolean m_IsFontUnderlined;
    private boolean m_IsFontStrikethrough;

    public Glint2DContext(Graphics2D graphics2D) {
        this.g = graphics2D;
        this.g.setColor(java.awt.Color.black);
        this.m_Pens.add(Pen.NONE);
        this.m_Colors.add(Color.NONE);
    }

    public URLMap getURLMap() {
        return this.m_URLMap;
    }

    public IGlint.ColorId addColor(Color color) {
        IGlint.ColorId colorId = new IGlint.ColorId(this.m_Colors.size());
        this.m_Colors.add(color);
        return colorId;
    }

    public IGlint.FontId addFont(Font font) {
        IGlint.FontId fontId = new IGlint.FontId(this.m_Fonts.size());
        this.m_Fonts.add(font);
        return fontId;
    }

    public IGlint.ImageId addImage(Image image) {
        IGlint.ImageId imageId = new IGlint.ImageId(this.m_Images.size());
        this.m_Images.add(image);
        return imageId;
    }

    public IGlint.PenId addPen(Pen pen) {
        IGlint.PenId penId = new IGlint.PenId(this.m_Pens.size());
        this.m_Pens.add(pen);
        return penId;
    }

    public void setColor(short s) {
        this.setColor(this.m_Colors.get(s).getAWTColor());
    }

    public void setColor(java.awt.Color color) {
        if (this.m_CurrentColor != color) {
            this.m_CurrentColor = color;
            if (color != null) {
                this.g.setColor(color);
            }
        }
    }

    public void setFont(IGlint.FontId fontId) {
        Font font = this.m_Fonts.get(fontId.id);
        this.g.setFont(font.getAWTFont());
        this.m_IsFontUnderlined = font.isUnderlined();
        this.m_IsFontStrikethrough = font.isStrikethrough();
    }

    public void setPen(IGlint.PenId penId) {
        Pen pen = this.m_Pens.get(penId.id);
        if (pen != null) {
            this.setColor(pen.getColor().getAWTColor());
            this.g.setStroke(this.getStroke(pen));
        }
    }

    public Font getFont(IGlint.FontId fontId) {
        return this.m_Fonts.get(fontId.id);
    }

    public Color getColor(IGlint.ColorId colorId) {
        return this.m_Colors.get(colorId.id);
    }

    public Image getImage(IGlint.ImageId imageId) {
        return this.m_Images.get(imageId.id);
    }

    public Pen getPen(IGlint.PenId penId) {
        return this.m_Pens.get(penId.id);
    }

    public boolean isFontUnderlined() {
        return this.m_IsFontUnderlined;
    }

    public boolean isFontStrikethrough() {
        return this.m_IsFontStrikethrough;
    }

    public boolean hasURL() {
        return this.m_CurrentURL != null;
    }

    public void setURL(String string, String string2) {
        if (this.m_CurrentURL != null) {
            this.m_URLs.push(this.m_CurrentURL);
        }
        this.m_CurrentURL = new URLMap.URLStruct(string, string2);
    }

    public void resetURL() {
        if (this.m_CurrentURL != null) {
            this.m_URLMap.addURLStruct(this.m_CurrentURL);
            this.m_CurrentURL = this.m_URLs.size() > 0 ? this.m_URLs.pop() : null;
        }
    }

    public void addURLShape(Shape shape) {
        if (this.m_CurrentURL != null) {
            this.m_CurrentURL.addShape(shape);
        }
    }

    public void pushClip(Shape shape) {
        this.m_ClipRects.push(shape);
    }

    public Shape popClip() {
        return this.m_ClipRects.pop();
    }

    public IGlint.StringId addString() {
        IGlint.StringId stringId = new IGlint.StringId(this.m_Strings.size());
        this.m_Strings.add("");
        return stringId;
    }

    public void setString(IGlint.StringId stringId, String string) {
        this.m_Strings.set(stringId.id, string);
    }

    public String getString(IGlint.StringId stringId) {
        if (stringId.id >= this.m_Strings.size()) {
            return null;
        }
        return this.m_Strings.get(stringId.id);
    }

    private Stroke getStroke(Pen pen) {
        Stroke stroke = this.m_Strokes.get(pen);
        if (stroke == null) {
            stroke = GlintGraphics2D.getStroke(pen.getWidth(), pen.getStyle());
            this.m_Strokes.put(pen, stroke);
        }
        return stroke;
    }
}

