/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.imageio;

import com.elixirtech.glint.EyeReader;
import com.elixirtech.glint.g2d.GlintGraphics2D;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class GlintImageReader
extends ImageReader {
    private ImageInputStream m_InputStream;
    private EyeReader m_Reader;

    public GlintImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (object == null) {
            this.m_InputStream = null;
        }
        if (!(object instanceof ImageInputStream)) {
            throw new IllegalArgumentException("Only ImageInputStreams are accepted.");
        }
        this.m_InputStream = (ImageInputStream)object;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.checkImageIndex(n);
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        this.buildReader();
        return this.m_Reader.getPageCount();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        return null;
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkImageIndex(n);
        return this.m_Reader.getHeight() / 20;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkImageIndex(n);
        return this.m_Reader.getWidth() / 20;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkImageIndex(n);
        BufferedImage bufferedImage = new BufferedImage(this.m_Reader.getWidth() / 20, this.m_Reader.getHeight() / 20, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        GlintGraphics2D glintGraphics2D = new GlintGraphics2D(graphics2D);
        this.m_Reader.getResources(glintGraphics2D);
        this.m_Reader.getPage(n + 1, glintGraphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void checkImageIndex(int n) throws IOException {
        this.buildReader();
        if (n < 0 || n >= this.m_Reader.getPageCount()) {
            throw new IOException("Image index error. No such image " + n);
        }
    }

    private void buildReader() throws IOException {
        if (this.m_Reader == null) {
            this.m_Reader = new EyeReader(this.m_InputStream);
        }
    }
}

