/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.print;

import com.elixirtech.glint.EyeReader;
import com.elixirtech.glint.IEye;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.g2d.GlintGraphics2D;
import com.elixirtech.glint.print.PrinterUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class GlintPrintable
implements Printable,
Pageable {
    private IEye m_Eye;
    private Dimension m_PhysicalPageSize;

    public GlintPrintable(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.m_Eye = new EyeReader(fileInputStream);
        }
    }

    public GlintPrintable(InputStream inputStream) throws IOException {
        this.m_Eye = new EyeReader(inputStream);
    }

    public GlintPrintable(IEye iEye) {
        this.m_Eye = iEye;
    }

    public void setPhysicalPageSize(Dimension dimension) {
        this.m_PhysicalPageSize = dimension;
    }

    @Override
    public int getNumberOfPages() {
        if (this.m_Eye == null) {
            return 0;
        }
        return this.m_Eye.getPageCount();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Object object;
        if (n < 0 || n >= this.m_Eye.getPageCount()) {
            return 1;
        }
        double d = 100.0;
        if (this.m_PhysicalPageSize != null) {
            object = this.m_Eye.getPageSetup(n + 1);
            PageFormat pageFormat2 = PrinterUtil.getPageFormat((IEye.PageSetup)object);
            double d2 = pageFormat.getWidth() / pageFormat2.getWidth();
            double d3 = pageFormat.getHeight() / pageFormat2.getHeight();
            d = Math.min(d2, d3) * 100.0;
        }
        object = new GlintGraphics2D((Graphics2D)graphics, d);
        this.m_Eye.getResources((IGlint)object);
        this.m_Eye.getPage(n + 1, (IGlint)object);
        return 0;
    }

    @Override
    public PageFormat getPageFormat(int n) {
        IEye.PageSetup pageSetup = this.m_Eye.getPageSetup(n + 1);
        if (this.m_PhysicalPageSize == null) {
            return PrinterUtil.getPageFormat(pageSetup);
        }
        return PrinterUtil.getScaledPageFormat(pageSetup, this.m_PhysicalPageSize);
    }

    @Override
    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.m_Eye.getPageCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }
}

