/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.xml;

import com.elixirtech.arch.ByteUtil;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.ConstBytes;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GlintException;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.IResourceManager;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ResourceManagerXML
implements IResourceManager {
    private ContentHandler m_Handler;
    private Map<String, IGlint.FontId> m_FontMap = new HashMap<String, IGlint.FontId>();
    private Map<String, IGlint.ColorId> m_ColorMap = new HashMap<String, IGlint.ColorId>();
    private Map<String, IGlint.ImageId> m_ImageMap = new HashMap<String, IGlint.ImageId>();
    private Map<String, IGlint.PenId> m_PenMap = new HashMap<String, IGlint.PenId>();
    private List<Font> m_FontList = new ArrayList<Font>();
    private List<Color> m_ColorList = new ArrayList<Color>();
    private List<Image> m_ImageList = new ArrayList<Image>();
    private List<Pen> m_PenList = new ArrayList<Pen>();
    private List<String> m_StringList = new ArrayList<String>();

    public ResourceManagerXML(ContentHandler contentHandler) {
        this.m_Handler = contentHandler;
        this.initConstants();
    }

    private void initConstants() {
        this.m_PenMap.put(this.getKey(Pen.NONE), new IGlint.PenId(0));
        this.m_PenList.add(Pen.NONE);
        this.m_ColorMap.put(this.getKey(Color.NONE), new IGlint.ColorId(0));
        this.m_ColorList.add(Color.NONE);
    }

    @Override
    public IGlint.FontId defineFont(Font font) {
        String string = this.getKey(font);
        IGlint.FontId fontId = this.m_FontMap.get(string);
        if (fontId == null) {
            int n = font.getType();
            fontId = new IGlint.FontId(this.m_FontList.size());
            this.m_FontMap.put(string, fontId);
            this.m_FontList.add(font);
            if (n == 1) {
                AttributesImpl attributesImpl = new AttributesImpl();
                this.setAttr(attributesImpl, "name", font.getName());
                this.setAttr(attributesImpl, "style", this.getFontStyle(font.getStyle()));
                this.setAttr(attributesImpl, "size", font.getSize());
                this.setAttr(attributesImpl, "id", fontId.id);
                this.startElement("font", attributesImpl);
                this.endElement("font");
            } else if (n == 2) {
                AttributesImpl attributesImpl = new AttributesImpl();
                this.setAttr(attributesImpl, "name", font.getName());
                this.setAttr(attributesImpl, "style", this.getFontStyle(font.getStyle()));
                this.setAttr(attributesImpl, "size", font.getSize());
                this.setAttr(attributesImpl, "id", fontId.id);
                this.startElement("embedded-font", attributesImpl);
                try {
                    ConstBytes constBytes = ((Font.ByteFont)font).getBytes();
                    String string2 = ByteUtil.encodeBase64(constBytes.bytes());
                    this.m_Handler.characters(string2.toCharArray(), 0, string2.length());
                }
                catch (Exception exception) {
                    throw new GlintException("embedded-font(" + font.getName() + ")", exception);
                }
                this.endElement("embedded-font");
            } else if (n == 3) {
                Font font2 = ((Font.DerivedFont)font).getBase();
                String string3 = this.getKey(font2);
                IGlint.FontId fontId2 = this.m_FontMap.get(string3);
                if (fontId2 == null) {
                    throw new GlintException("Undefined base font used for derivation");
                }
                AttributesImpl attributesImpl = new AttributesImpl();
                this.setAttr(attributesImpl, "base", fontId2.id);
                this.setAttr(attributesImpl, "style", this.getFontStyle(font.getStyle()));
                this.setAttr(attributesImpl, "size", font.getSize());
                this.setAttr(attributesImpl, "id", fontId.id);
                this.startElement("derived-font", attributesImpl);
                this.endElement("derived-font");
            }
        }
        return fontId;
    }

    @Override
    public IGlint.ColorId defineColor(Color color) {
        String string = this.getKey(color);
        IGlint.ColorId colorId = this.m_ColorMap.get(string);
        if (colorId == null) {
            colorId = new IGlint.ColorId(this.m_ColorList.size());
            this.m_ColorMap.put(string, colorId);
            this.m_ColorList.add(color);
            AttributesImpl attributesImpl = new AttributesImpl();
            this.setAttr(attributesImpl, "rgb", color.getRGB());
            this.setAttr(attributesImpl, "id", colorId.id);
            this.startElement("color", attributesImpl);
            this.endElement("color");
        }
        return colorId;
    }

    @Override
    public IGlint.ImageId defineImage(Image image) {
        String string = this.getKey(image);
        IGlint.ImageId imageId = this.m_ImageMap.get(string);
        if (imageId == null) {
            imageId = new IGlint.ImageId(this.m_ImageList.size());
            if (string != null) {
                this.m_ImageMap.put(string, imageId);
            }
            this.m_ImageList.add(image);
            int n = image.getDataType();
            if (n == 1) {
                int n2 = image.getWidth();
                int n3 = image.getHeight();
                AttributesImpl attributesImpl = new AttributesImpl();
                this.setAttr(attributesImpl, "width", n2);
                this.setAttr(attributesImpl, "height", n3);
                this.setAttr(attributesImpl, "id", imageId.id);
                this.startElement("rgb-image", attributesImpl);
                try {
                    int[] nArray = (int[])image.getData();
                    String string2 = ByteUtil.encodeBase64(nArray);
                    this.m_Handler.characters(string2.toCharArray(), 0, string2.length());
                }
                catch (Exception exception) {
                    throw new GlintException("rgb-image exception", exception);
                }
                this.endElement("rgb-image");
            } else {
                AttributesImpl attributesImpl = new AttributesImpl();
                this.setAttr(attributesImpl, "id", imageId.id);
                this.startElement("image", attributesImpl);
                try {
                    byte[] byArray = (byte[])image.getData();
                    String string3 = ByteUtil.encodeBase64(byArray);
                    this.m_Handler.characters(string3.toCharArray(), 0, string3.length());
                }
                catch (Exception exception) {
                    throw new GlintException("rgb-image exception", exception);
                }
                this.endElement("image");
            }
        }
        return imageId;
    }

    @Override
    public IGlint.PenId definePen(Pen pen) {
        String string = this.getKey(pen);
        IGlint.PenId penId = this.m_PenMap.get(string);
        if (penId == null) {
            penId = new IGlint.PenId(this.m_PenList.size());
            this.m_PenMap.put(string, penId);
            this.m_PenList.add(pen);
            IGlint.ColorId colorId = this.defineColor(pen.getColor());
            AttributesImpl attributesImpl = new AttributesImpl();
            this.setAttr(attributesImpl, "color-ref", colorId.id);
            this.setAttr(attributesImpl, "style", this.getPenStyle(pen.getStyle()));
            this.setAttr(attributesImpl, "width", pen.getWidth());
            this.setAttr(attributesImpl, "id", penId.id);
            this.startElement("pen", attributesImpl);
            this.endElement("pen");
        }
        return penId;
    }

    @Override
    public IGlint.StringId defineString() {
        IGlint.StringId stringId = new IGlint.StringId(this.m_StringList.size());
        this.m_StringList.add("");
        return stringId;
    }

    @Override
    public void setString(IGlint.StringId stringId, String string) {
        this.m_StringList.set(stringId.id, string);
    }

    @Override
    public Font getFont(IGlint.FontId fontId) {
        return this.m_FontList.get(fontId.id);
    }

    @Override
    public Color getColor(IGlint.ColorId colorId) {
        return this.m_ColorList.get(colorId.id);
    }

    @Override
    public Image getImage(IGlint.ImageId imageId) {
        return this.m_ImageList.get(imageId.id);
    }

    @Override
    public Pen getPen(IGlint.PenId penId) {
        return this.m_PenList.get(penId.id);
    }

    @Override
    public String getString(IGlint.StringId stringId) {
        return this.m_StringList.get(stringId.id);
    }

    @Override
    public int getFontCount() {
        return this.m_FontList.size();
    }

    @Override
    public int getColorCount() {
        return this.m_ColorList.size();
    }

    @Override
    public int getImageCount() {
        return this.m_ImageList.size();
    }

    @Override
    public int getPenCount() {
        return this.m_PenList.size();
    }

    @Override
    public int getStringCount() {
        return this.m_StringList.size();
    }

    private String getKey(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getName());
        stringBuffer.append('|');
        stringBuffer.append(font.getSize());
        stringBuffer.append('|');
        stringBuffer.append(font.getStyle());
        return stringBuffer.toString();
    }

    private String getKey(Color color) {
        if (color == Color.NONE) {
            return "None";
        }
        return Integer.toString(color.getRGB());
    }

    private String getKey(Image image) {
        return image.getId();
    }

    private String getKey(Pen pen) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(pen.getColor().getRGB());
        stringBuffer.append('|');
        stringBuffer.append(pen.getWidth());
        stringBuffer.append('|');
        stringBuffer.append(pen.getStyle());
        return stringBuffer.toString();
    }

    private String getFontStyle(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append("bold");
        } else {
            stringBuffer.append("plain");
        }
        if ((n & 2) != 0) {
            return " italic";
        }
        if ((n & 4) != 0) {
            return " underlined";
        }
        return stringBuffer.toString();
    }

    private String getPenStyle(int n) {
        if (n == 1) {
            return "solid";
        }
        if (n == 2) {
            return "dashed";
        }
        if (n == 3) {
            return "dotted";
        }
        return "";
    }

    private void setAttr(AttributesImpl attributesImpl, String string, int n) {
        this.setAttr(attributesImpl, string, Integer.toString(n));
    }

    private void setAttr(AttributesImpl attributesImpl, String string, String string2) {
        attributesImpl.addAttribute("", string, string, "CDATA", string2);
    }

    private void startElement(String string, Attributes attributes) {
        try {
            this.m_Handler.startElement("http://www.elixirtech.com/Glint", string, "gl:" + string, attributes);
        }
        catch (SAXException sAXException) {
            throw new GlintException("startElement(" + string + ")", sAXException);
        }
    }

    private void endElement(String string) {
        try {
            this.m_Handler.endElement("http://www.elixirtech.com/Glint", string, "gl:" + string);
        }
        catch (SAXException sAXException) {
            throw new GlintException("endElement(" + string + ")", sAXException);
        }
    }
}

