/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.graphics.util.DoubleStroke;
import com.elixirtech.graphics.util.WaveStroke;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;

public class BorderStyle {
    private static final Map<String, BorderStyle> BORDER_STYLE_MAP = new HashMap<String, BorderStyle>();
    public static final int NONE_ID = 0;
    public static final int SOLID_ID = 1;
    public static final int DASHED_ID = 2;
    public static final int DOTTED_ID = 3;
    public static final int DOUBLE_ID = 4;
    public static final int GROOVE_ID = 5;
    public static final int RIDGE_ID = 6;
    public static final int INSET_ID = 7;
    public static final int OUTSET_ID = 8;
    public static final int DOTDASH_ID = 9;
    public static final int DOTDOTDASH_ID = 10;
    public static final int WAVE_ID = 11;
    public static final BorderStyle NONE = new BorderStyle("None", 0);
    public static final BorderStyle SOLID = new BorderStyle("Solid", 1);
    public static final BorderStyle DASHED = new BorderStyle("Dashed", 2);
    public static final BorderStyle DOTTED = new BorderStyle("Dotted", 3);
    public static final BorderStyle DOUBLE = new BorderStyle("Double", 4);
    public static final BorderStyle GROOVE = new BorderStyle("Groove", 5);
    public static final BorderStyle RIDGE = new BorderStyle("Ridge", 6);
    public static final BorderStyle INSET = new BorderStyle("Inset", 7);
    public static final BorderStyle OUTSET = new BorderStyle("Outset", 8);
    public static final BorderStyle DOTDASH = new BorderStyle("DotDash", 9);
    public static final BorderStyle DOTDOTDASH = new BorderStyle("DotDotDash", 10);
    public static final BorderStyle WAVE = new BorderStyle("Wave", 11);
    public final String NAME;
    public final int ID;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(BorderStyle.class);
    private static final BorderStyle[] ARRAY = new BorderStyle[]{NONE, SOLID, DASHED, DOTTED, DOUBLE, GROOVE, RIDGE, INSET, OUTSET, DOTDASH, DOTDOTDASH, WAVE};

    public static BorderStyle get(String string) {
        if (string == null || string == "") {
            return NONE;
        }
        BorderStyle borderStyle = BORDER_STYLE_MAP.get(string);
        if (borderStyle == null) {
            m_Log.error((Object)("Unknown border style: " + string));
            borderStyle = NONE;
        }
        return borderStyle;
    }

    public static BorderStyle get(int n) {
        if (n < 0 || n >= ARRAY.length) {
            return null;
        }
        return ARRAY[n];
    }

    protected BorderStyle(String string, int n) {
        this.NAME = string;
        this.ID = n;
        BORDER_STYLE_MAP.put(this.NAME, this);
    }

    public static Stroke getStroke(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Width error: " + n);
        }
        int n3 = n;
        if (n3 == 0) {
            n3 = 1;
        }
        switch (n2) {
            case 1: {
                return new BasicStroke(n, 0, 0);
            }
            case 2: {
                return new BasicStroke(n, 0, 0, 20.0f, new float[]{n3 * 5, n3 * 2}, 0.0f);
            }
            case 3: {
                return new BasicStroke(n, 0, 0, 20.0f, new float[]{n3, n3}, 0.0f);
            }
            case 9: {
                return new BasicStroke(n, 0, 0, 20.0f, new float[]{n3, n3, n3 * 5, n3}, 0.0f);
            }
            case 10: {
                return new BasicStroke(n, 0, 0, 20.0f, new float[]{n3, n3, n3, n3, n3 * 5, n3}, 0.0f);
            }
            case 11: {
                return new WaveStroke(20.0f, n3 * 5, (float)n3 / 2.0f);
            }
            case 4: {
                return new DoubleStroke(n);
            }
        }
        return null;
    }
}

