/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics;

import com.elixirtech.graphics.GString;
import com.elixirtech.graphics.Orientation;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.FontBox;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.font.RotatedGlyphFontMeasurer;
import com.elixirtech.graphics.font.Span;
import com.elixirtech.graphics.font.TextLine;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class GStringCalculations {
    private final GString m_GString;
    private int m_Height;
    private List<FontBox> m_Boxes;
    private List<TextLine> m_Lines;

    public GStringCalculations(GString gString) {
        this.m_GString = gString;
        this.buildBoxes();
        this.layoutBoxes();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public Iterator<TextLine> getLines() {
        return this.m_Lines.iterator();
    }

    protected final void buildBoxes() {
        String string = this.m_GString.m_String;
        this.m_Boxes = new ArrayList<FontBox>();
        int[] nArray = this.m_GString.m_SpanHolder.getBreaks();
        for (int i = 0; i < nArray.length - 1; ++i) {
            int n = nArray[i];
            Font font = this.buildFont(n);
            Orientation orientation = this.buildOrientation(n);
            IFontMeasurer iFontMeasurer = this.m_GString.m_FontMeasurerFactory.getInstance(font);
            int n2 = nArray[i + 1];
            this.m_Boxes.add(this.buildBox(string.substring(n, n2), font, iFontMeasurer, orientation));
        }
    }

    protected Font buildFont(int n) {
        Span[] spanArray = this.m_GString.m_SpanHolder.getSpans(n);
        Font font = spanArray[0].getFont();
        for (int i = 1; i < spanArray.length; ++i) {
            Font font2 = spanArray[i].getFont();
            if (font2 == null) continue;
            font = font.merge(font2);
        }
        return font;
    }

    protected Orientation buildOrientation(int n) {
        Span[] spanArray = this.m_GString.m_SpanHolder.getSpans(n);
        Orientation orientation = this.m_GString.m_GlyphOrientation;
        for (int i = 0; i < spanArray.length; ++i) {
            Orientation orientation2 = spanArray[i].getOrientation();
            if (orientation2 == null) continue;
            orientation = orientation.add(orientation2);
        }
        return orientation;
    }

    protected FontBox buildBox(String string, Font font, IFontMeasurer iFontMeasurer, Orientation orientation) {
        Rectangle rectangle = new Rectangle();
        FontBox fontBox = new FontBox(string, font, rectangle);
        if (orientation == Orientation.ANGLE_0) {
            rectangle.width = (int)iFontMeasurer.getWidth(string);
            rectangle.height = (int)iFontMeasurer.getHeight();
        } else {
            fontBox.buildOrientation(this.m_GString.m_BaselineOrientation, orientation);
            RotatedGlyphFontMeasurer rotatedGlyphFontMeasurer = new RotatedGlyphFontMeasurer(iFontMeasurer);
            int n = string.length();
            rectangle.width = rotatedGlyphFontMeasurer.getWidth(string, fontBox.getGlyphOrientation(), 0, n);
            rectangle.height = rotatedGlyphFontMeasurer.getHeight(string, fontBox.getGlyphOrientation(), 0, n);
        }
        return fontBox;
    }

    protected final void layoutBoxes() {
        TextLine textLine = new TextLine(this.m_GString);
        textLine.addLast(this.m_Boxes);
        this.m_Lines = new ArrayList<TextLine>();
        this.m_Lines.add(textLine);
        Orientation orientation = this.m_GString.m_BaselineOrientation;
        if (orientation == Orientation.ANGLE_0 || orientation == Orientation.ANGLE_180) {
            this.layoutHorizontal(textLine);
            this.layoutLines();
            TextLine textLine2 = this.m_Lines.get(this.m_Lines.size() - 1);
            int n = textLine2.getY() + textLine2.getHeight();
            if (n > this.m_Height && this.m_GString.m_CanGrow) {
                this.m_Height = n;
            }
            if (n < this.m_Height && this.m_GString.m_CanShrink) {
                this.m_Height = n;
            }
        } else {
            this.layoutVertical(textLine);
            this.layoutLines();
        }
    }

    protected void layoutHorizontal(TextLine textLine) {
        Rectangle rectangle = this.m_GString.m_Rectangle;
        if (textLine.getWidth() > rectangle.width) {
            List<FontBox> list = textLine.split(rectangle.width);
            TextLine textLine2 = new TextLine(this.m_GString);
            textLine2.addLast(list);
            this.m_Lines.add(textLine2);
            this.layoutHorizontal(textLine2);
        }
    }

    protected void layoutVertical(TextLine textLine) {
        TextLine textLine2 = textLine;
        if (this.m_GString.m_CanGrow || this.m_GString.m_CanShrink) {
            int n;
            int n2 = textLine2.getHeight();
            Rectangle rectangle = this.m_GString.m_Rectangle;
            int n3 = n = n2 == 0 ? 1 : Math.max(1, rectangle.width / n2);
            if (n > 1) {
                int n4 = textLine2.getWidth() / ++n;
                while (textLine2.getWidth() > n4) {
                    List<FontBox> list = textLine2.split(n4);
                    textLine2 = new TextLine(this.m_GString);
                    textLine2.addLast(list);
                    this.m_Lines.add(textLine2);
                }
            }
        } else {
            Rectangle rectangle = this.m_GString.m_Rectangle;
            this.m_Height = rectangle.height;
            if (textLine2.getWidth() > rectangle.height) {
                List<FontBox> list = textLine2.split(rectangle.width);
                TextLine textLine3 = new TextLine(this.m_GString);
                textLine3.addLast(list);
                this.m_Lines.add(textLine3);
                this.layoutVertical(textLine3);
            }
        }
    }

    protected void layoutLines() {
        int n = 0;
        for (TextLine textLine : this.m_Lines) {
            textLine.setY(n);
            n += textLine.getHeight();
        }
        this.m_Height = n;
    }
}

