/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics;

public final class Orientation {
    public static final Orientation ANGLE_0 = new Orientation(0, 0);
    public static final Orientation ANGLE_90 = new Orientation(90, 1);
    public static final Orientation ANGLE_180 = new Orientation(180, 2);
    public static final Orientation ANGLE_270;
    public static final Orientation ANGLE_MINUS_90;
    public static final Orientation ANGLE_MINUS_180;
    public static final Orientation ANGLE_MINUS_270;
    private int m_Angle;
    private byte m_Id;

    public static Orientation[] getChoices() {
        return new Orientation[]{ANGLE_0, ANGLE_90, ANGLE_180, ANGLE_270};
    }

    public static Orientation get(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Orientation.get(n);
    }

    public static Orientation get(int n) {
        int n2;
        for (n2 = n; n2 < 0; n2 += 360) {
        }
        while (n2 > 360) {
            n2 -= 360;
        }
        if (n2 < 90) {
            return ANGLE_0;
        }
        if (n2 < 180) {
            return ANGLE_90;
        }
        if (n2 < 270) {
            return ANGLE_180;
        }
        return ANGLE_270;
    }

    public static Orientation inverse(Orientation orientation) {
        if (orientation == ANGLE_0) {
            return ANGLE_0;
        }
        if (orientation == ANGLE_90) {
            return ANGLE_270;
        }
        if (orientation == ANGLE_180) {
            return ANGLE_180;
        }
        return ANGLE_90;
    }

    private Orientation(int n, int n2) {
        this.m_Angle = n;
        this.m_Id = (byte)n2;
    }

    public Orientation add(Orientation orientation) {
        return Orientation.get(this.m_Angle + orientation.m_Angle);
    }

    public int getAngle() {
        return this.m_Angle;
    }

    public byte getId() {
        return this.m_Id;
    }

    public String toString() {
        return String.valueOf(this.m_Angle);
    }

    static {
        ANGLE_MINUS_90 = ANGLE_270 = new Orientation(270, 3);
        ANGLE_MINUS_180 = ANGLE_180;
        ANGLE_MINUS_270 = ANGLE_90;
    }
}

