/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.font;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.font.IFontMeasurerFactory;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.util.HashMap;
import java.util.Map;

public class AWTFontMeasurerFactory
implements IFontMeasurerFactory {
    private Map<Font, IFontMeasurer> m_Map = new HashMap<Font, IFontMeasurer>();
    private static FontRenderContext m_FRC = new FontRenderContext(null, true, true);

    @Override
    public IFontMeasurer getInstance(Font font) {
        IFontMeasurer iFontMeasurer = this.m_Map.get(font);
        if (iFontMeasurer == null) {
            iFontMeasurer = new AWTFontMeasurer(font);
            this.m_Map.put(font, iFontMeasurer);
        }
        return iFontMeasurer;
    }

    public IFontMeasurer getInstance(java.awt.Font font) {
        return new AWTFontMeasurer(font);
    }

    private static class AWTFontMeasurer
    implements IFontMeasurer {
        private java.awt.Font m_Font;
        private LineMetrics m_LineMetrics;

        public AWTFontMeasurer(Font font) {
            int n = font.isBold() ? 1 : 0;
            this.m_Font = new java.awt.Font(font.getName(), n |= font.isItalic() ? 2 : 0, font.getSize() / 20);
            this.m_Font = this.m_Font.deriveFont((float)font.getSize() / 20.0f);
            this.m_LineMetrics = this.m_Font.getLineMetrics("Sample characters", m_FRC);
        }

        public AWTFontMeasurer(java.awt.Font font) {
            this.m_Font = font;
            this.m_LineMetrics = this.m_Font.getLineMetrics("Sample characters", m_FRC);
        }

        @Override
        public float getWidth(String string) {
            if (StringUtil.isEmpty(string)) {
                return 0.0f;
            }
            return (float)this.m_Font.getStringBounds(string, m_FRC).getWidth() * 20.0f;
        }

        @Override
        public float getSpacedWidth(String string) {
            if (string == null || string.length() == 0) {
                return 0.0f;
            }
            return (float)this.m_Font.getStringBounds(string, m_FRC).getWidth() * 20.0f;
        }

        @Override
        public float getWidth(String string, int n, int n2) {
            return this.getWidth(string.substring(n, n + n2));
        }

        @Override
        public float getWidth(char[] cArray, int n, int n2) {
            return (float)this.m_Font.getStringBounds(cArray, n, n2, m_FRC).getWidth() * 20.0f;
        }

        @Override
        public float getHeight() {
            return this.m_LineMetrics.getHeight() * 20.0f;
        }

        @Override
        public float getAscent() {
            return this.m_LineMetrics.getAscent() * 20.0f;
        }

        @Override
        public float getDescent() {
            return this.m_LineMetrics.getDescent() * 20.0f;
        }

        @Override
        public float getLeading() {
            return this.m_LineMetrics.getLeading() * 20.0f;
        }

        @Override
        public float getCharWidth(char c) {
            return this.getWidth(new char[]{c}, 0, 1);
        }
    }
}

