/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.font;

import com.elixirtech.glint.ConstBytes;
import com.elixirtech.graphics.font.FontBox;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.font.TextLine;
import java.awt.Graphics2D;

public class RotatedGlyphRenderer {
    public static final double NINETY_DEGREES = Math.toRadians(90.0);

    public static void draw(Graphics2D graphics2D, FontBox fontBox, int n, int n2, IFontMeasurer iFontMeasurer) {
        int n3 = n;
        ConstBytes constBytes = fontBox.m_GlyphOrientation;
        if (RotatedGlyphRenderer.all0(constBytes)) {
            graphics2D.drawString(fontBox.m_String, n3, n2);
        } else {
            int n4;
            float f = iFontMeasurer.getAscent() + iFontMeasurer.getDescent();
            char[] cArray = fontBox.m_String.toCharArray();
            int n5 = constBytes.length();
            int n6 = n4 = 0;
            TextLine textLine = fontBox.getLine();
            while (n4 < n5) {
                float f2;
                float f3;
                int n7;
                byte by = constBytes.get(n4);
                if (by == 0) {
                    n6 = RotatedGlyphRenderer.getEndOfSpan(constBytes, n4);
                    n7 = n6 - n4 + 1;
                    graphics2D.drawChars(cArray, n4, n7, n3, n2);
                    n3 = (int)((float)n3 + iFontMeasurer.getWidth(cArray, n4, n7));
                    n4 = n6 + 1;
                    continue;
                }
                if (by == 1) {
                    n7 = (int)iFontMeasurer.getCharWidth(cArray[n4]);
                    f3 = (float)n3 + iFontMeasurer.getDescent();
                    f2 = textLine.getY() + (textLine.getHeight() - n7) / 2;
                    graphics2D.translate(f3, f2);
                    graphics2D.rotate(NINETY_DEGREES);
                    graphics2D.drawChars(cArray, n4, 1, 0, 0);
                    graphics2D.rotate(-NINETY_DEGREES);
                    graphics2D.translate(-f3, -f2);
                    ++n6;
                    n3 = (int)((float)n3 + f);
                    ++n4;
                    continue;
                }
                if (by == 2) {
                    n7 = (int)iFontMeasurer.getCharWidth(cArray[n4]);
                    f3 = iFontMeasurer.getAscent() - iFontMeasurer.getDescent();
                    graphics2D.translate((double)(n3 + n7), (float)n2 - f3);
                    graphics2D.rotate(2.0 * NINETY_DEGREES);
                    graphics2D.drawChars(cArray, n4, 1, 0, 0);
                    graphics2D.rotate(-2.0 * NINETY_DEGREES);
                    graphics2D.translate((double)(-n3 - n7), (float)(-n2) + f3);
                    n3 += n7;
                    ++n4;
                    continue;
                }
                if (by != 3) continue;
                n7 = (int)iFontMeasurer.getCharWidth(cArray[n4]);
                f3 = (float)n3 + iFontMeasurer.getAscent();
                f2 = textLine.getY() + textLine.getHeight() - (textLine.getHeight() - n7) / 2;
                graphics2D.translate(f3, f2);
                graphics2D.rotate(-NINETY_DEGREES);
                graphics2D.drawChars(cArray, n4, 1, 0, 0);
                graphics2D.rotate(NINETY_DEGREES);
                graphics2D.translate(-f3, -f2);
                ++n4;
                n3 = (int)((float)n3 + f);
            }
        }
    }

    protected static int getEndOfSpan(ConstBytes constBytes, int n) {
        int n2 = n;
        int n3 = constBytes.length();
        byte by = constBytes.get(n2);
        do {
            if (++n2 != n3) continue;
            return n2 - 1;
        } while (constBytes.get(n2) == by);
        return n2 - 1;
    }

    protected static boolean all0(ConstBytes constBytes) {
        int n = constBytes.length();
        for (int i = 0; i < n; ++i) {
            if (constBytes.get(i) == 0) continue;
            return false;
        }
        return true;
    }
}

