/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.grid;

import com.elixirtech.graphics.GlyphOrientation;
import com.elixirtech.graphics.WritingMode;
import com.elixirtech.graphics.grid.Strip;
import com.elixirtech.util.CharUtil;
import java.util.ArrayList;

public class StripBuilder {
    public static Strip[] buildStrips(String string, int n, WritingMode writingMode, GlyphOrientation glyphOrientation) {
        if (n == 1) {
            return StripBuilder.buildIdeographStrips(string, writingMode, glyphOrientation);
        }
        return StripBuilder.buildAllStrips(string, writingMode, glyphOrientation);
    }

    public static Strip[] buildIdeographStrips(String string, WritingMode writingMode, GlyphOrientation glyphOrientation) {
        ArrayList<Strip> arrayList = new ArrayList<Strip>();
        boolean bl = true;
        if (writingMode == WritingMode.TB_RL || writingMode == WritingMode.TB_LR) {
            bl = glyphOrientation != GlyphOrientation.UPRIGHT;
        }
        int n = 0;
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = StripBuilder.charMode(c);
            if (n3 == 2) {
                if (stringBuffer.length() > 0) {
                    arrayList.add(new Strip(stringBuffer.toString(), n));
                    stringBuffer.setLength(0);
                }
                arrayList.add(new Strip(String.valueOf(c), n3));
            } else {
                if (n3 != n && stringBuffer.length() > 0) {
                    arrayList.add(new Strip(stringBuffer.toString(), n));
                    stringBuffer.setLength(0);
                }
                if (n3 == 1) {
                    if (bl) {
                        stringBuffer.append(c);
                    } else {
                        arrayList.add(new Strip(stringBuffer.toString(), n3));
                    }
                } else {
                    stringBuffer.append(c);
                }
            }
            n = n3;
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(new Strip(stringBuffer.toString(), n));
        }
        Strip[] stripArray = new Strip[arrayList.size()];
        arrayList.toArray(stripArray);
        return stripArray;
    }

    public static Strip[] buildAllStrips(String string, WritingMode writingMode, GlyphOrientation glyphOrientation) {
        ArrayList<Strip> arrayList = new ArrayList<Strip>();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = StripBuilder.charMode(c);
            if (n2 == 3) {
                stringBuffer.append(c);
                continue;
            }
            if (stringBuffer.length() > 0) {
                arrayList.add(new Strip(stringBuffer.toString(), 3));
                stringBuffer.setLength(0);
            }
            arrayList.add(new Strip(String.valueOf(c), n2));
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(new Strip(stringBuffer.toString(), 3));
        }
        Strip[] stripArray = new Strip[arrayList.size()];
        arrayList.toArray(stripArray);
        return stripArray;
    }

    private static int charMode(char c) {
        if (CharUtil.isCJK(c)) {
            return 2;
        }
        if (CharUtil.isJoined(c)) {
            return 3;
        }
        return 1;
    }
}

