/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.text;

import com.elixirtech.graphics.TextAlignment;
import com.elixirtech.graphics.text.TextLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TextBuilder {
    private float m_Width;
    private float m_Height;
    private AttributedString m_String;
    private TextAlignment m_Alignment = TextAlignment.LEFT;
    private boolean m_CanGrow;
    private List<TextLine> m_Layouts;
    private float m_FirstLineIndent;
    private Color m_ConstructionColor = CONSTRUCTION;
    private float m_ActualHeight;
    private int m_NextCharIndex;
    private float m_LineHeight;
    private static final Stroke THIN_LINE = new BasicStroke(0.0f);
    private static final Color CONSTRUCTION = Color.lightGray;
    private static final BreakIterator BREAK_ITERATOR = BreakIterator.getLineInstance();

    public void setDimension(float f, float f2) {
        this.m_Width = f;
        this.m_Height = f2;
    }

    public void setCanGrow(boolean bl) {
        this.m_CanGrow = bl;
        this.m_Layouts = null;
    }

    public void setFirstLineIndent(float f) {
        this.m_FirstLineIndent = f;
        this.m_Layouts = null;
    }

    public void setText(String string, Font font) {
        this.m_String = new AttributedString(string);
        this.m_String.addAttribute(TextAttribute.FONT, font);
        this.m_Layouts = null;
    }

    public void setText(AttributedString attributedString) {
        this.m_String = attributedString;
        this.m_Layouts = null;
    }

    public void setConstructionColor(Color color) {
        this.m_ConstructionColor = color;
    }

    public void setLineHeight(float f) {
        this.m_LineHeight = f / 20.0f;
    }

    public float getActualHeight() {
        return this.m_ActualHeight;
    }

    public int getNextCharIndex() {
        return this.m_NextCharIndex;
    }

    public int getLineCount() {
        if (this.m_Layouts == null) {
            return 0;
        }
        return this.m_Layouts.size();
    }

    public void setAlignment(TextAlignment textAlignment) {
        if (TextAlignment.JUSTIFY == this.m_Alignment) {
            this.m_Layouts = null;
        }
        this.m_Alignment = textAlignment;
        if (TextAlignment.JUSTIFY == textAlignment) {
            this.m_Layouts = null;
        }
    }

    public AttributedString getLine(int n) {
        TextLine textLine = this.m_Layouts.get(n);
        AttributedCharacterIterator attributedCharacterIterator = this.m_String.getIterator(null, textLine.beginIndex, textLine.endIndex);
        return new AttributedString(attributedCharacterIterator);
    }

    public TextLine getTextLine(int n) {
        return this.m_Layouts.get(n);
    }

    public AttributedString getString() {
        return this.m_String;
    }

    public void render(Graphics2D graphics2D, float f, float f2, int n, boolean bl) {
        if (this.m_String == null || this.m_Width <= 0.0f || this.m_Height <= 0.0f) {
            return;
        }
        if (this.m_Layouts == null) {
            this.buildLayouts(graphics2D.getFontRenderContext(), n);
        }
        boolean bl2 = n == 0;
        Iterator<TextLine> iterator = this.m_Layouts.iterator();
        float f3 = f2;
        while (iterator.hasNext()) {
            float f4 = f3;
            float f5 = f;
            if (this.m_Width > this.m_FirstLineIndent) {
                if (bl2 && this.m_FirstLineIndent > 0.0f) {
                    f5 += this.m_FirstLineIndent;
                } else if (this.m_FirstLineIndent < 0.0f && !bl2) {
                    f5 -= this.m_FirstLineIndent;
                }
            }
            TextLine textLine = iterator.next();
            TextLayout textLayout = textLine.layout;
            f3 += textLine.layout.getAscent();
            if (bl) {
                Line2D.Float float_ = new Line2D.Float(f, f3, f + this.m_Width, f3);
                graphics2D.setStroke(THIN_LINE);
                graphics2D.setColor(this.m_ConstructionColor);
                graphics2D.draw(float_);
            }
            graphics2D.setColor(Color.black);
            if (this.m_Alignment == TextAlignment.RIGHT) {
                f5 = f + this.m_Width - textLayout.getAdvance();
            } else if (this.m_Alignment == TextAlignment.CENTER) {
                f5 = f + (this.m_Width - textLayout.getAdvance()) / 2.0f;
            }
            if (!textLayout.isLeftToRight()) {
                f5 += textLayout.getAdvance();
            }
            textLayout.draw(graphics2D, f5, f3);
            f3 = this.m_LineHeight == 0.0f ? (f3 += textLayout.getDescent() + textLayout.getLeading()) : f4 + this.m_LineHeight;
            bl2 = false;
        }
        if (bl) {
            // empty if block
        }
    }

    public void buildLayouts(FontRenderContext fontRenderContext, int n) {
        if (this.m_String == null || this.m_Width <= 0.0f || this.m_Height <= 0.0f) {
            return;
        }
        this.m_NextCharIndex = n;
        this.m_Layouts = new ArrayList<TextLine>();
        int n2 = this.m_String.getIterator().getEndIndex();
        AttributedCharacterIterator attributedCharacterIterator = this.m_String.getIterator(null, n, n2);
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, (BreakIterator)BREAK_ITERATOR.clone(), fontRenderContext);
        boolean bl = n == 0;
        this.m_ActualHeight = 0.0f;
        while (lineBreakMeasurer.getPosition() < n2) {
            float f = this.m_Width;
            if (this.m_Width > this.m_FirstLineIndent) {
                if (bl && this.m_FirstLineIndent > 0.0f) {
                    f -= this.m_FirstLineIndent;
                } else if (this.m_FirstLineIndent < 0.0f && !bl) {
                    f += this.m_FirstLineIndent;
                }
            }
            TextLine textLine = new TextLine();
            textLine.beginIndex = lineBreakMeasurer.getPosition();
            textLine.layout = lineBreakMeasurer.nextLayout(f);
            if (this.m_Alignment == TextAlignment.JUSTIFY && lineBreakMeasurer.getPosition() < n2) {
                textLine.layout = textLine.layout.getJustifiedLayout(f);
            }
            textLine.endIndex = lineBreakMeasurer.getPosition();
            TextLayout textLayout = textLine.layout;
            float f2 = textLayout.getAscent();
            if (!this.m_CanGrow && this.m_ActualHeight + f2 > this.m_Height) break;
            this.m_NextCharIndex = textLine.endIndex;
            if (this.m_LineHeight == 0.0f) {
                this.m_ActualHeight += f2 + textLayout.getDescent();
                this.m_ActualHeight += textLayout.getLeading();
            } else {
                this.m_ActualHeight += this.m_LineHeight;
            }
            this.m_Layouts.add(textLine);
            bl = false;
        }
    }
}

