/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.http.client;

import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.package$;
import java.io.Serializable;
import java.net.URL;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.runtime.ModuleSerializationProxy;

public final class DigestGet$
implements Serializable {
    private static final String TestURL;
    private static final String TestUser;
    private static final String TestPass;
    public static final DigestGet$ MODULE$;

    private DigestGet$() {
    }

    static {
        MODULE$ = new DigestGet$();
        TestURL = "https://jigsaw.w3.org/HTTP/Digest/";
        TestUser = "guest";
        TestPass = "guest";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DigestGet$.class);
    }

    public String TestURL() {
        return TestURL;
    }

    public String TestUser() {
        return TestUser;
    }

    public String TestPass() {
        return TestPass;
    }

    public void main(String[] args) {
        if (args.length == 3) {
            Predef$.MODULE$.println((Object)this.getText(new URL(args[0]), args[1], args[2]));
            return;
        }
        Predef$.MODULE$.println((Object)"Expected <url> <user> <pass>");
    }

    public String getText(URL url, String user, String password) {
        return new String(this.getBytes(url, user, password), "UTF-8");
    }

    public byte[] getBytes(URL url, String user, String password) {
        HttpHost targetHost = new HttpHost(url.getHost(), url.getPort());
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(url.toString());
        return (byte[])ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            CloseableHttpResponse response = (CloseableHttpResponse)arm.manage((Object)httpClient.execute(targetHost, (HttpRequest)httpget));
            if (response.getStatusLine().getStatusCode() == 401) {
                this.debug((Function0<String>)((Function0 & Serializable)() -> this.getBytes$$anonfun$1$$anonfun$1(response)));
                Header header = response.getFirstHeader("WWW-Authenticate");
                this.debug((Function0<String>)((Function0 & Serializable)() -> this.getBytes$$anonfun$1$$anonfun$2(header)));
                return this.handleChallenge(url, user, password, header);
            }
            this.debug((Function0<String>)((Function0 & Serializable)this::getBytes$$anonfun$1$$anonfun$3));
            return package$.MODULE$.enrichInputStream(response.getEntity().getContent()).contents();
        });
    }

    public byte[] handleChallenge(URL url, String user, String password, Header challenge) {
        HttpHost targetHost = new HttpHost(url.getHost(), url.getPort());
        CloseableHttpClient httpClient = HttpClients.createDefault();
        DigestScheme scheme = new DigestScheme();
        scheme.processChallenge(challenge);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(user, password);
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget2 = new HttpGet(url.toString());
        Header newHeader = scheme.authenticate((Credentials)creds, (HttpRequest)httpget2, (HttpContext)context);
        this.debug((Function0<String>)((Function0 & Serializable)() -> this.handleChallenge$$anonfun$1(newHeader)));
        httpget2.addHeader(newHeader);
        return (byte[])ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            CloseableHttpResponse response2 = (CloseableHttpResponse)arm.manage((Object)httpClient.execute(targetHost, (HttpRequest)httpget2));
            this.debug((Function0<String>)((Function0 & Serializable)() -> this.handleChallenge$$anonfun$2$$anonfun$1(response2)));
            this.debug((Function0<String>)((Function0 & Serializable)() -> this.handleChallenge$$anonfun$2$$anonfun$2(response2)));
            return package$.MODULE$.enrichInputStream(response2.getEntity().getContent()).contents();
        });
    }

    public void debug(Function0<String> s) {
    }

    private final String getBytes$$anonfun$1$$anonfun$1(CloseableHttpResponse response$1) {
        return "response1: " + response$1.getStatusLine();
    }

    private final String getBytes$$anonfun$1$$anonfun$2(Header header$1) {
        return "challenge header: " + header$1;
    }

    private final String getBytes$$anonfun$1$$anonfun$3() {
        return "No digest needed";
    }

    private final String handleChallenge$$anonfun$1(Header newHeader$1) {
        return "New Header: " + newHeader$1;
    }

    private final String handleChallenge$$anonfun$2$$anonfun$1(CloseableHttpResponse response2$1) {
        return "response2: " + response2$1.getStatusLine();
    }

    private final String handleChallenge$$anonfun$2$$anonfun$2(CloseableHttpResponse response2$2) {
        return Predef$.MODULE$.wrapRefArray((Object[])response2$2.getAllHeaders()).toList().map((Function1 & Serializable)h -> h.getName() + "=" + h.getValue()).mkString("\n");
    }
}

