/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.http.client;

import com.elixirtech.arch.Token$;
import com.elixirtech.arch.security.Authentication$;
import com.elixirtech.http.client.Request;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Request$
implements Mirror.Product,
Serializable {
    private static final Charset UTF8;
    private static final ContentType OctetStreamContentType;
    public static final Request$ MODULE$;

    private Request$() {
    }

    static {
        MODULE$ = new Request$();
        UTF8 = Charset.forName("UTF-8");
        OctetStreamContentType = ContentType.create((String)"application/octet-stream");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Request$.class);
    }

    public Request apply(HttpHost host, String method, String path, Option<Credentials> creds, List<Tuple2<String, String>> headers, Option<HttpEntity> body, Charset defaultCharset, boolean redirects) {
        return new Request(host, method, path, creds, headers, body, defaultCharset, redirects);
    }

    public Request unapply(Request x$1) {
        return x$1;
    }

    public Option<Credentials> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public List<Tuple2<String, String>> $lessinit$greater$default$5() {
        return package$.MODULE$.Nil();
    }

    public Option<HttpEntity> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Charset $lessinit$greater$default$7() {
        return this.UTF8();
    }

    public boolean $lessinit$greater$default$8() {
        return true;
    }

    public Charset UTF8() {
        return UTF8;
    }

    public ContentType OctetStreamContentType() {
        return OctetStreamContentType;
    }

    public HttpHost buildHost(String uriString) {
        URI uri = URI.create(uriString);
        return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
    }

    public String buildPath(String uriString) {
        URI uri = URI.create(uriString);
        return uri.getRawPath() + this.queryString(uri);
    }

    public Tuple2<HttpHost, String> buildHostPath(String uriString) {
        URI uri = URI.create(uriString);
        Predef$.MODULE$.require(uri.getHost() != null, () -> this.buildHostPath$$anonfun$1(uriString));
        HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        String path = uri.getRawPath() + this.queryString(uri);
        return Tuple2$.MODULE$.apply((Object)host, (Object)path);
    }

    public Tuple2<HttpHost, String> buildRelativeHostPath(String uriString) {
        URI uri = URI.create(uriString);
        HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        String path = uri.getRawPath() + this.queryString(uri);
        return Tuple2$.MODULE$.apply((Object)host, (Object)path);
    }

    public Request apply(String method, String uriString) {
        return this.apply(method, uriString, true);
    }

    public Request apply(String method, String uriString, boolean withToken) {
        Tuple2<HttpHost, String> tuple2 = this.buildHostPath(uriString);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HttpHost host = (HttpHost)tuple2._1();
        String path = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)host, (Object)path);
        HttpHost host2 = (HttpHost)tuple22._1();
        String path2 = (String)tuple22._2();
        Nil$ headers = withToken ? (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.tokenHeader()})) : package$.MODULE$.Nil();
        return this.apply(host2, method, path2, (Option<Credentials>)None$.MODULE$, (List<Tuple2<String, String>>)headers, this.$lessinit$greater$default$6(), this.$lessinit$greater$default$7(), this.$lessinit$greater$default$8());
    }

    public Tuple2<String, String> tokenHeader() {
        return Tuple2$.MODULE$.apply((Object)"Authorization", (Object)(Token$.MODULE$.HttpPrefix() + Authentication$.MODULE$.token()));
    }

    private String queryString(URI uri) {
        return (String)Option$.MODULE$.apply((Object)uri.getRawQuery()).map((Function1 & Serializable)_$1 -> "?" + _$1).getOrElse(this::queryString$$anonfun$2);
    }

    public String com$elixirtech$http$client$Request$$$UrlEncodedFormEntity$superArg$1(Request request, Iterable<Tuple2<String, String>> params) {
        return request.form_join((Iterable)Option$.MODULE$.option2Iterable(request.body().map((Function1 & Serializable)x$0 -> EntityUtils.toString((HttpEntity)x$0)).filterNot((Function1 & Serializable)_$2 -> _$2.isEmpty())).toSeq().$plus$plus((IterableOnce)params.map((Function1 & Serializable)value -> request.form_elem((Tuple2)value))));
    }

    public Request fromProduct(Product x$0) {
        return new Request((HttpHost)x$0.productElement(0), (String)x$0.productElement(1), (String)x$0.productElement(2), (Option<Credentials>)((Option)x$0.productElement(3)), (List<Tuple2<String, String>>)((List)x$0.productElement(4)), (Option<HttpEntity>)((Option)x$0.productElement(5)), (Charset)x$0.productElement(6), BoxesRunTime.unboxToBoolean((Object)x$0.productElement(7)));
    }

    private final Object buildHostPath$$anonfun$1(String uriString$1) {
        return "uri host is null in " + uriString$1;
    }

    private final String queryString$$anonfun$2() {
        return "";
    }
}

