/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jaxen.dom;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class NamespaceNode
implements Node {
    public static final short NAMESPACE_NODE = 13;
    private Node parent;
    private String name;
    private String value;
    private HashMap userData = new HashMap();

    public NamespaceNode(Node node, String string, String string2) {
        this.parent = node;
        this.name = string;
        this.value = string2;
    }

    NamespaceNode(Node node, Node node2) {
        String string = node2.getNodeName();
        this.name = string.equals("xmlns") ? "" : (string.startsWith("xmlns:") ? string.substring(6) : string);
        this.parent = node;
        this.value = node2.getNodeValue();
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public String getNodeValue() {
        return this.value;
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
        this.disallowModification();
    }

    @Override
    public short getNodeType() {
        return 13;
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public NodeList getChildNodes() {
        return new EmptyNodeList();
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getOwnerDocument();
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        this.disallowModification();
        return null;
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.disallowModification();
        return null;
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        this.disallowModification();
        return null;
    }

    @Override
    public Node appendChild(Node node) throws DOMException {
        this.disallowModification();
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public Node cloneNode(boolean bl) {
        return new NamespaceNode(this.parent, this.name, this.value);
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String string, String string2) {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String string) throws DOMException {
        this.disallowModification();
    }

    @Override
    public String getLocalName() {
        return this.name;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    private void disallowModification() throws DOMException {
        throw new DOMException(7, "Namespace node may not be modified");
    }

    public int hashCode() {
        return this.hashCode(this.parent) + this.hashCode(this.name) + this.hashCode(this.value);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof NamespaceNode) {
            NamespaceNode namespaceNode = (NamespaceNode)object;
            return this.equals(this.parent, namespaceNode.getParentNode()) && this.equals(this.name, namespaceNode.getNodeName()) && this.equals(this.value, namespaceNode.getNodeValue());
        }
        return false;
    }

    private int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    private boolean equals(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }

    @Override
    public String getBaseURI() {
        Class<Node> clazz = Node.class;
        try {
            Class[] classArray = new Class[]{};
            Method method = clazz.getMethod("getBaseURI", classArray);
            String string = (String)method.invoke((Object)this.getParentNode(), (Object[])classArray);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public short compareDocumentPosition(Node node) throws DOMException {
        DOMException dOMException = new DOMException(9, "DOM level 3 interfaces are not fully implemented in Jaxen's NamespaceNode class");
        throw dOMException;
    }

    @Override
    public String getTextContent() {
        return this.value;
    }

    @Override
    public void setTextContent(String string) throws DOMException {
        this.disallowModification();
    }

    @Override
    public boolean isSameNode(Node node) {
        boolean bl;
        boolean bl2 = this.isEqualNode(node);
        Node node2 = this.getParentNode();
        Node node3 = node.getParentNode();
        try {
            Class<Node> clazz = Node.class;
            Class[] classArray = new Class[]{clazz};
            Method method = clazz.getMethod("isEqual", classArray);
            Object[] objectArray = new Object[]{node3};
            Boolean bl3 = (Boolean)method.invoke((Object)node2, objectArray);
            bl = bl3;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = node2.equals(node3);
        }
        catch (InvocationTargetException invocationTargetException) {
            bl = node2.equals(node3);
        }
        catch (IllegalAccessException illegalAccessException) {
            bl = node2.equals(node3);
        }
        return bl2 && bl;
    }

    @Override
    public String lookupPrefix(String string) {
        try {
            Class<Node> clazz = Node.class;
            Class[] classArray = new Class[]{String.class};
            Method method = clazz.getMethod("lookupPrefix", classArray);
            Object[] objectArray = new Object[]{string};
            String string2 = (String)method.invoke((Object)this.parent, objectArray);
            return string2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UnsupportedOperationException("Cannot lookup prefixes in DOM 2");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Cannot lookup prefixes in DOM 2");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Cannot lookup prefixes in DOM 2");
        }
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        return string.equals(this.lookupNamespaceURI(null));
    }

    @Override
    public String lookupNamespaceURI(String string) {
        try {
            Class<Node> clazz = Node.class;
            Class[] classArray = new Class[]{String.class};
            Method method = clazz.getMethod("lookupNamespaceURI", classArray);
            Object[] objectArray = new Object[]{string};
            String string2 = (String)method.invoke((Object)this.parent, objectArray);
            return string2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UnsupportedOperationException("Cannot lookup namespace URIs in DOM 2");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Cannot lookup namespace URIs in DOM 2");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Cannot lookup namespace URIs in DOM 2");
        }
    }

    @Override
    public boolean isEqualNode(Node node) {
        if (node.getNodeType() == this.getNodeType()) {
            NamespaceNode namespaceNode = (NamespaceNode)node;
            if (namespaceNode.name == null && this.name != null) {
                return false;
            }
            if (namespaceNode.name != null && this.name == null) {
                return false;
            }
            if (namespaceNode.value == null && this.value != null) {
                return false;
            }
            if (namespaceNode.value != null && this.value == null) {
                return false;
            }
            if (namespaceNode.name == null && this.name == null) {
                return namespaceNode.value.equals(this.value);
            }
            return namespaceNode.name.equals(this.name) && namespaceNode.value.equals(this.value);
        }
        return false;
    }

    @Override
    public Object getFeature(String string, String string2) {
        return null;
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        Object object2 = this.getUserData(string);
        this.userData.put(string, object);
        return object2;
    }

    @Override
    public Object getUserData(String string) {
        return this.userData.get(string);
    }

    private static class EmptyNodeList
    implements NodeList {
        private EmptyNodeList() {
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public Node item(int n) {
            return null;
        }
    }
}

