/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jaxen.expr;

import com.elixirtech.jaxen.Context;
import com.elixirtech.jaxen.ContextSupport;
import com.elixirtech.jaxen.JaxenException;
import com.elixirtech.jaxen.expr.Predicate;
import com.elixirtech.jaxen.function.BooleanFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PredicateSet
implements Serializable {
    private static final long serialVersionUID = -7166491740228977853L;
    private List<Predicate> predicates = Collections.emptyList();

    public void addPredicate(Predicate predicate) {
        if (this.predicates == Collections.EMPTY_LIST) {
            this.predicates = new ArrayList<Predicate>();
        }
        this.predicates.add(predicate);
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    public void simplify() {
        Iterator<Predicate> iterator = this.predicates.iterator();
        Predicate predicate = null;
        while (iterator.hasNext()) {
            predicate = iterator.next();
            predicate.simplify();
        }
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Predicate> iterator = this.predicates.iterator();
        Predicate predicate = null;
        while (iterator.hasNext()) {
            predicate = iterator.next();
            stringBuffer.append(predicate.getText());
        }
        return stringBuffer.toString();
    }

    protected boolean evaluateAsBoolean(List<?> list, ContextSupport contextSupport) throws JaxenException {
        return this.anyMatchingNode(list, contextSupport);
    }

    private boolean anyMatchingNode(List<?> list, ContextSupport contextSupport) throws JaxenException {
        if (this.predicates.size() == 0) {
            return false;
        }
        Iterator<Predicate> iterator = this.predicates.iterator();
        List<?> list2 = list;
        while (iterator.hasNext()) {
            int n = list2.size();
            Context context = new Context(contextSupport);
            ArrayList arrayList = new ArrayList(1);
            context.setNodeSet(arrayList);
            for (int i = 0; i < n; ++i) {
                Boolean bl;
                int n2;
                Object obj = list2.get(i);
                arrayList.clear();
                arrayList.add(obj);
                context.setNodeSet(arrayList);
                context.setPosition(i + 1);
                context.setSize(n);
                Object object = iterator.next().evaluate(context);
                if (!(object instanceof Number ? (n2 = ((Number)object).intValue()) == i + 1 : (bl = BooleanFunction.evaluate(object, context.getNavigator())) != false)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<?> evaluatePredicates(List<?> list, ContextSupport contextSupport) throws JaxenException {
        if (this.predicates.size() == 0) {
            return list;
        }
        Iterator<Predicate> iterator = this.predicates.iterator();
        List<?> list2 = list;
        while (iterator.hasNext()) {
            list2 = this.applyPredicate(iterator.next(), list2, contextSupport);
        }
        return list2;
    }

    public List<?> applyPredicate(Predicate predicate, List<?> list, ContextSupport contextSupport) throws JaxenException {
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        Context context = new Context(contextSupport);
        ArrayList arrayList2 = new ArrayList(1);
        context.setNodeSet(arrayList2);
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            arrayList2.clear();
            arrayList2.add(obj);
            context.setNodeSet(arrayList2);
            context.setPosition(i + 1);
            context.setSize(n);
            Object object = predicate.evaluate(context);
            if (object instanceof Number) {
                int n2 = ((Number)object).intValue();
                if (n2 != i + 1) continue;
                arrayList.add(obj);
                continue;
            }
            Boolean bl = BooleanFunction.evaluate(object, context.getNavigator());
            if (!bl.booleanValue()) continue;
            arrayList.add(obj);
        }
        return arrayList;
    }
}

