/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jaxen.function;

import com.elixirtech.jaxen.Context;
import com.elixirtech.jaxen.Function;
import com.elixirtech.jaxen.FunctionCallException;
import com.elixirtech.jaxen.Navigator;
import com.elixirtech.jaxen.function.StringFunction;
import java.util.List;

public class StringLengthFunction
implements Function {
    @Override
    public Object call(Context context, List list) throws FunctionCallException {
        if (list.size() == 0) {
            return StringLengthFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (list.size() == 1) {
            return StringLengthFunction.evaluate(list.get(0), context.getNavigator());
        }
        throw new FunctionCallException("string-length() requires one argument.");
    }

    public static Double evaluate(Object object, Navigator navigator) throws FunctionCallException {
        String string = StringFunction.evaluate(object, navigator);
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            ++n;
            if (c < '\ud800') continue;
            try {
                char c2 = cArray[i + 1];
                if (c2 < '\udc00' || c2 > '\udfff') {
                    throw new FunctionCallException("Bad surrogate pair in string " + string);
                }
                ++i;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new FunctionCallException("Bad surrogate pair in string " + string);
            }
        }
        return new Double(n);
    }
}

