/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jaxen.jdom;

import com.elixirtech.jaxen.DefaultNavigator;
import com.elixirtech.jaxen.FunctionCallException;
import com.elixirtech.jaxen.JaxenConstants;
import com.elixirtech.jaxen.NamedAccessNavigator;
import com.elixirtech.jaxen.Navigator;
import com.elixirtech.jaxen.XPath;
import com.elixirtech.jaxen.jdom.JDOMXPath;
import com.elixirtech.jaxen.jdom.XPathNamespace;
import com.elixirtech.jaxen.saxpath.SAXPathException;
import com.elixirtech.jaxen.util.SingleObjectIterator;
import com.elixirtech.jdom.Attribute;
import com.elixirtech.jdom.CDATA;
import com.elixirtech.jdom.Comment;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.jdom.Parent;
import com.elixirtech.jdom.ProcessingInstruction;
import com.elixirtech.jdom.Text;
import com.elixirtech.jdom.input.SAXBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DocumentNavigator
extends DefaultNavigator
implements NamedAccessNavigator {
    private static final long serialVersionUID = -1636727587303584165L;

    public static Navigator getInstance() {
        return Singleton.instance;
    }

    @Override
    public boolean isElement(Object object) {
        return object instanceof Element;
    }

    @Override
    public boolean isComment(Object object) {
        return object instanceof Comment;
    }

    @Override
    public boolean isText(Object object) {
        return object instanceof Text || object instanceof CDATA;
    }

    @Override
    public boolean isAttribute(Object object) {
        return object instanceof Attribute;
    }

    @Override
    public boolean isProcessingInstruction(Object object) {
        return object instanceof ProcessingInstruction;
    }

    @Override
    public boolean isDocument(Object object) {
        return object instanceof Document;
    }

    @Override
    public boolean isNamespace(Object object) {
        return object instanceof Namespace || object instanceof XPathNamespace;
    }

    @Override
    public String getElementName(Object object) {
        Element element = (Element)object;
        return element.getName();
    }

    @Override
    public String getElementNamespaceUri(Object object) {
        Element element = (Element)object;
        String string = element.getNamespaceURI();
        if (string != null && string.length() == 0) {
            return null;
        }
        return string;
    }

    @Override
    public String getAttributeName(Object object) {
        Attribute attribute = (Attribute)object;
        return attribute.getName();
    }

    @Override
    public String getAttributeNamespaceUri(Object object) {
        Attribute attribute = (Attribute)object;
        String string = attribute.getNamespaceURI();
        if (string != null && string.length() == 0) {
            return null;
        }
        return string;
    }

    @Override
    public Iterator getChildAxisIterator(Object object) {
        if (object instanceof Element) {
            return ((Element)object).getContent().iterator();
        }
        if (object instanceof Document) {
            return ((Document)object).getContent().iterator();
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    @Override
    public Iterator getChildAxisIterator(Object object, String string, String string2, String string3) {
        if (object instanceof Element) {
            Element element = (Element)object;
            if (string3 == null) {
                return element.getChildren(string).iterator();
            }
            return element.getChildren(string, Namespace.getNamespace(string2, string3)).iterator();
        }
        if (object instanceof Document) {
            Document document = (Document)object;
            Element element = document.getRootElement();
            if (!element.getName().equals(string)) {
                return JaxenConstants.EMPTY_ITERATOR;
            }
            if (string3 != null ? !Namespace.getNamespace(string2, string3).equals(element.getNamespace()) : element.getNamespace() != Namespace.NO_NAMESPACE) {
                return JaxenConstants.EMPTY_ITERATOR;
            }
            return new SingleObjectIterator(element);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    @Override
    public Iterator getNamespaceAxisIterator(Object object) {
        if (!(object instanceof Element)) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        Element element = (Element)object;
        HashMap<String, XPathNamespace> hashMap = new HashMap<String, XPathNamespace>();
        Element element2 = element;
        while (element2 != null) {
            Namespace namespace2 = element2.getNamespace();
            if (namespace2 != Namespace.NO_NAMESPACE && !hashMap.containsKey(namespace2.getPrefix())) {
                hashMap.put(namespace2.getPrefix(), new XPathNamespace(element, namespace2));
            }
            for (Namespace namespace2 : element2.getAdditionalNamespaces()) {
                if (hashMap.containsKey(namespace2.getPrefix())) continue;
                hashMap.put(namespace2.getPrefix(), new XPathNamespace(element, namespace2));
            }
            for (Attribute attribute : element2.getAttributes()) {
                Namespace namespace3 = attribute.getNamespace();
                if (namespace3 == Namespace.NO_NAMESPACE || hashMap.containsKey(namespace3.getPrefix())) continue;
                hashMap.put(namespace3.getPrefix(), new XPathNamespace(element, namespace3));
            }
            if (element2.getParent() instanceof Element) {
                element2 = (Element)element2.getParent();
                continue;
            }
            element2 = null;
        }
        hashMap.put("xml", new XPathNamespace(element, Namespace.XML_NAMESPACE));
        return hashMap.values().iterator();
    }

    @Override
    public Iterator getParentAxisIterator(Object object) {
        Parent parent = null;
        if (object instanceof Document) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        if (object instanceof Element) {
            parent = ((Element)object).getParent();
            if (parent == null && ((Element)object).isRootElement()) {
                parent = ((Element)object).getDocument();
            }
        } else if (object instanceof Attribute) {
            parent = ((Attribute)object).getParent();
        } else if (object instanceof XPathNamespace) {
            parent = ((XPathNamespace)object).getJDOMElement();
        } else if (object instanceof ProcessingInstruction) {
            parent = ((ProcessingInstruction)object).getParent();
        } else if (object instanceof Comment) {
            parent = ((Comment)object).getParent();
        } else if (object instanceof Text) {
            parent = ((Text)object).getParent();
        }
        if (parent != null) {
            return new SingleObjectIterator(parent);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    @Override
    public Iterator getAttributeAxisIterator(Object object) {
        if (!(object instanceof Element)) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        Element element = (Element)object;
        return element.getAttributes().iterator();
    }

    @Override
    public Iterator getAttributeAxisIterator(Object object, String string, String string2, String string3) {
        Namespace namespace;
        Element element;
        Attribute attribute;
        if (object instanceof Element && (attribute = (element = (Element)object).getAttribute(string, namespace = string3 == null ? Namespace.NO_NAMESPACE : Namespace.getNamespace(string2, string3))) != null) {
            return new SingleObjectIterator(attribute);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    @Override
    public XPath parseXPath(String string) throws SAXPathException {
        return new JDOMXPath(string);
    }

    @Override
    public Object getDocumentNode(Object object) {
        if (object instanceof Document) {
            return object;
        }
        Element element = (Element)object;
        return element.getDocument();
    }

    @Override
    public String getElementQName(Object object) {
        Element element = (Element)object;
        String string = element.getNamespacePrefix();
        if (string == null || string.length() == 0) {
            return element.getName();
        }
        return string + ":" + element.getName();
    }

    @Override
    public String getAttributeQName(Object object) {
        Attribute attribute = (Attribute)object;
        String string = attribute.getNamespacePrefix();
        if (string == null || "".equals(string)) {
            return attribute.getName();
        }
        return string + ":" + attribute.getName();
    }

    @Override
    public String getNamespaceStringValue(Object object) {
        if (object instanceof Namespace) {
            Namespace namespace = (Namespace)object;
            return namespace.getURI();
        }
        XPathNamespace xPathNamespace = (XPathNamespace)object;
        return xPathNamespace.getJDOMNamespace().getURI();
    }

    @Override
    public String getNamespacePrefix(Object object) {
        if (object instanceof Namespace) {
            Namespace namespace = (Namespace)object;
            return namespace.getPrefix();
        }
        XPathNamespace xPathNamespace = (XPathNamespace)object;
        return xPathNamespace.getJDOMNamespace().getPrefix();
    }

    @Override
    public String getTextStringValue(Object object) {
        if (object instanceof Text) {
            return ((Text)object).getText();
        }
        if (object instanceof CDATA) {
            return ((CDATA)object).getText();
        }
        return "";
    }

    @Override
    public String getAttributeStringValue(Object object) {
        Attribute attribute = (Attribute)object;
        return attribute.getValue();
    }

    @Override
    public String getElementStringValue(Object object) {
        Element element = (Element)object;
        StringBuffer stringBuffer = new StringBuffer();
        List<Content> list = element.getContent();
        Iterator<Content> iterator = list.iterator();
        Content content = null;
        while (iterator.hasNext()) {
            content = iterator.next();
            if (content instanceof Text) {
                stringBuffer.append(((Text)content).getText());
                continue;
            }
            if (content instanceof CDATA) {
                stringBuffer.append(((CDATA)content).getText());
                continue;
            }
            if (!(content instanceof Element)) continue;
            stringBuffer.append(this.getElementStringValue(content));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProcessingInstructionTarget(Object object) {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
        return processingInstruction.getTarget();
    }

    @Override
    public String getProcessingInstructionData(Object object) {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
        return processingInstruction.getData();
    }

    @Override
    public String getCommentStringValue(Object object) {
        Comment comment = (Comment)object;
        return comment.getText();
    }

    @Override
    public String translateNamespacePrefixToUri(String string, Object object) {
        Namespace namespace;
        Element element = null;
        if (object instanceof Element) {
            element = (Element)object;
        } else if (object instanceof Text) {
            element = (Element)((Text)object).getParent();
        } else if (object instanceof Attribute) {
            element = ((Attribute)object).getParent();
        } else if (object instanceof XPathNamespace) {
            element = ((XPathNamespace)object).getJDOMElement();
        } else if (object instanceof Comment) {
            element = (Element)((Comment)object).getParent();
        } else if (object instanceof ProcessingInstruction) {
            element = (Element)((ProcessingInstruction)object).getParent();
        }
        if (element != null && (namespace = element.getNamespace(string)) != null) {
            return namespace.getURI();
        }
        return null;
    }

    @Override
    public Object getDocument(String string) throws FunctionCallException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            return sAXBuilder.build(string);
        }
        catch (Exception exception) {
            throw new FunctionCallException(exception.getMessage());
        }
    }

    private static class Singleton {
        private static DocumentNavigator instance = new DocumentNavigator();

        private Singleton() {
        }
    }
}

