/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom;

import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Parent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DescendantIterator
implements Iterator<Object> {
    private Iterator iterator;
    private Iterator nextIterator;
    private List<Iterator> stack = new ArrayList<Iterator>();

    DescendantIterator(Parent parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent parameter was null");
        }
        this.iterator = parent.getContent().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator != null && this.iterator.hasNext()) {
            return true;
        }
        if (this.nextIterator != null && this.nextIterator.hasNext()) {
            return true;
        }
        return this.stackHasAnyNext();
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.nextIterator != null) {
            this.push(this.iterator);
            this.iterator = this.nextIterator;
            this.nextIterator = null;
        }
        while (!this.iterator.hasNext()) {
            if (this.stack.size() > 0) {
                this.iterator = this.pop();
                continue;
            }
            throw new NoSuchElementException("Somehow we lost our iterator");
        }
        Content content = (Content)this.iterator.next();
        if (content instanceof Element) {
            this.nextIterator = ((Element)content).getContent().iterator();
        }
        return content;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    private Iterator pop() {
        int n = this.stack.size();
        if (n == 0) {
            throw new NoSuchElementException("empty stack");
        }
        return this.stack.remove(n - 1);
    }

    private void push(Iterator iterator) {
        this.stack.add(iterator);
    }

    private boolean stackHasAnyNext() {
        int n = this.stack.size();
        for (int i = 0; i < n; ++i) {
            Iterator iterator = this.stack.get(i);
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }
}

