/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.js;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.js.Environment;
import com.elixirtech.js.JavaScriptEngine;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.serialize.ScriptableOutputStream;

public class Global
extends ImporterTopLevel {
    private static final long serialVersionUID = 1L;
    private static final String[] NAMES = new String[]{"print", "println", "version", "load", "loadClass", "defineClass", "serialize", "importScript", "exists"};
    static final String PRIVATE_NAME = "com.elixirtech.js.Global private";
    public transient InputStream inStream;
    public transient PrintStream outStream;
    public transient PrintStream errStream;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Global.class);
    private static String m_BasicFunctions;

    public Global(Context context) {
        super(context);
        this.defineFunctionProperties(NAMES, Global.class, 2);
        this.defineProperty(PRIVATE_NAME, (Object)this, 2);
        Environment.defineClass((ScriptableObject)this);
        Environment environment = new Environment((ScriptableObject)this);
        this.defineProperty("environment", (Object)environment, 2);
        this.loadBasicFunctions(context);
    }

    public void loadBasicFunctions(Context context) {
        try {
            JavaScriptEngine.evaluateReader(context, (Scriptable)this, new StringReader(m_BasicFunctions), "BasicFunctions.js", 1, JavaScriptEngine.getSystemCodeSource());
        }
        catch (Exception exception) {
            m_Log.error((Object)"Can't initialize BasicFunctions.js");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadExtensionFunctions(Context context) {
        InputStreamReader inputStreamReader = null;
        try {
            m_Log.debug((Object)"Loading ExtensionFunctions.js");
            inputStreamReader = new InputStreamReader(Global.class.getResourceAsStream("ExtensionFunctions.js"), "UTF-8");
            JavaScriptEngine.evaluateReader(context, (Scriptable)this, inputStreamReader, "ExtensionFunctions.js", 1, JavaScriptEngine.getSystemCodeSource());
            m_Log.debug((Object)"Finished loading ExtensionFunctions.js");
        }
        catch (Exception exception) {
            m_Log.error((Object)"Can't initialize ExtensionFunctions.js");
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (Exception exception) {
                m_Log.error((Object)("Error closing extensions: " + exception));
            }
        }
    }

    public static Object print(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        PrintStream printStream = Global.getInstance(scriptable).getOut();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                printStream.print(" ");
            }
            String string = Context.toString((Object)objectArray[i]);
            printStream.print(string);
        }
        return Context.getUndefinedValue();
    }

    public static Object println(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        PrintStream printStream = Global.getInstance(scriptable).getOut();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                printStream.print(" ");
            }
            String string = Context.toString((Object)objectArray[i]);
            printStream.print(string);
        }
        printStream.println();
        return Context.getUndefinedValue();
    }

    public static double version(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = context.getLanguageVersion();
        if (objectArray.length > 0) {
            double d2 = Context.toNumber((Object)objectArray[0]);
            context.setLanguageVersion((int)d2);
        }
        return d;
    }

    public static void load(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        for (int i = 0; i < objectArray.length; ++i) {
            JavaScriptEngine.processFile(context, scriptable, Context.toString((Object)objectArray[i]));
        }
    }

    public static void defineClass(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Class<? extends Scriptable> clazz = Global.getClass(objectArray);
        ScriptableObject.defineClass((Scriptable)scriptable, clazz);
    }

    public static void loadClass(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IllegalAccessException, InstantiationException, InvocationTargetException, JavaScriptException {
        Class<? extends Scriptable> clazz = Global.getClass(objectArray);
        if (!Script.class.isAssignableFrom(clazz)) {
            throw Context.reportRuntimeError((String)("Class " + clazz.getName() + " must implement Script"));
        }
        Script script = (Script)clazz.newInstance();
        script.exec(context, scriptable);
    }

    public static Object exists(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length > 0) {
            Object object = scriptable.get(String.valueOf(objectArray[0]), scriptable);
            return object == NOT_FOUND ? Boolean.FALSE : Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Class<? extends Scriptable> getClass(Object[] objectArray) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (objectArray.length == 0) {
            throw Context.reportRuntimeError((String)"A string argument was expected");
        }
        String string = Context.toString((Object)objectArray[0]);
        try {
            Class<?> clazz = Class.forName(string);
            if (Scriptable.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            throw Context.reportRuntimeError((String)("Class " + string + " is not a kind of Scriptable"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw Context.reportRuntimeError((String)("Class " + string + " not found"));
        }
    }

    public static void serialize(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        if (objectArray.length < 2) {
            throw Context.reportRuntimeError((String)"Usage: serialize(object,filename)");
        }
        Object object = objectArray[0];
        String string = Context.toString((Object)objectArray[1]);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope((Scriptable)scriptable);
        ScriptableOutputStream scriptableOutputStream = new ScriptableOutputStream((OutputStream)fileOutputStream, scriptable2);
        scriptableOutputStream.writeObject(object);
        scriptableOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importScript(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        for (int i = 0; i < objectArray.length; ++i) {
            String string = objectArray[i].toString();
            try (Reader reader = null;){
                reader = JavaScriptEngine.resolveScript(string);
                if (reader != null) {
                    JavaScriptEngine.evaluateReader(context, scriptable, reader, string, 1);
                    continue;
                }
                throw new IOException("Cannot locate script " + string);
            }
        }
    }

    public InputStream getIn() {
        return this.inStream == null ? System.in : this.inStream;
    }

    public void setIn(InputStream inputStream) {
        this.inStream = inputStream;
    }

    public PrintStream getOut() {
        return this.outStream == null ? System.out : this.outStream;
    }

    public void setOut(PrintStream printStream) {
        this.outStream = printStream;
    }

    public PrintStream getErr() {
        return this.errStream == null ? System.err : this.errStream;
    }

    public void setErr(PrintStream printStream) {
        this.errStream = printStream;
    }

    public static Global getInstance(Scriptable scriptable) {
        Object object = ScriptableObject.getProperty((Scriptable)scriptable, (String)PRIVATE_NAME);
        if (object instanceof Global) {
            return (Global)((Object)object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        StringWriter stringWriter = new StringWriter();
        Reader reader = null;
        char[] cArray = new char[1024];
        try {
            int n;
            reader = new InputStreamReader(Global.class.getResourceAsStream("BasicFunctions.js"), "UTF-8");
            while ((n = reader.read(cArray)) > 0) {
                stringWriter.write(cArray, 0, n);
            }
            m_BasicFunctions = stringWriter.toString();
        }
        catch (IOException iOException) {
            m_Log.error((Object)"Can't load basic functions");
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {
                m_Log.error((Object)"Error closing extensions");
            }
        }
    }
}

