/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.js;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IServer;
import com.elixirtech.arch.ServerImpl;
import com.elixirtech.arch.TerminateException;
import com.elixirtech.arch.util.URLUtil;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.Environment;
import com.elixirtech.js.ErrorHandler;
import com.elixirtech.js.Global;
import com.elixirtech.js.ILogger;
import com.elixirtech.js.IScriptResolver;
import com.elixirtech.js.LoggerProxy;
import com.elixirtech.js.PrivilegedJavaProxy;
import com.elixirtech.js.RepertoireClassShutter;
import com.elixirtech.js.RhinoSecurityController;
import com.elixirtech.js.ScriptException;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.repository.RMLRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class JavaScriptEngine {
    public static final String OPTIMIZATION = "elixir.js.optimizationLevel";
    public static final String JAVASCRIPT_CODESOURCE_USER = "http://www.elixirtech.com/user/javascript";
    public static final String JAVASCRIPT_CODESOURCE_SYSTEM = "http://www.elixirtech.com/system/javascript";
    private static ThreadLocal<JavaScriptEngine> m_ThreadEngine = new ThreadLocal();
    private static RhinoSecurityController m_SecurityController = new RhinoSecurityController();
    private static CodeSource m_UserCodeSource;
    private static CodeSource m_SystemCodeSource;
    private static RepertoireClassShutter m_ClassShutter;
    private int m_OptimizationLevel = -1;
    private Context m_Context;
    private Object m_UndefinedValue;
    private Scriptable m_Global;
    private Scriptable m_Scope;
    private Map<Object, Scriptable> m_ScriptableCache;
    private ErrorReporter m_ErrorReporter = new ErrorHandler();
    private static IScriptResolver m_Resolver;
    private static IServer m_Server;
    private static ElxLoggerJ m_Log;
    private static ILogger m_ExecLog;

    public static JavaScriptEngine getInstance() {
        JavaScriptEngine javaScriptEngine = m_ThreadEngine.get();
        if (javaScriptEngine == null) {
            javaScriptEngine = new JavaScriptEngine();
            m_ThreadEngine.set(javaScriptEngine);
        }
        return javaScriptEngine;
    }

    public static void disposeInstance() {
        JavaScriptEngine javaScriptEngine = m_ThreadEngine.get();
        if (javaScriptEngine != null) {
            m_ThreadEngine.set(null);
            Context.exit();
        }
    }

    protected JavaScriptEngine() {
        String string = System.getProperty(OPTIMIZATION);
        if (string != null && string.trim().length() > 0) {
            try {
                this.m_OptimizationLevel = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_ScriptableCache = new HashMap<Object, Scriptable>();
        this.m_Context = Context.enter();
        try {
            this.m_Context.setSecurityController((SecurityController)m_SecurityController);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            this.m_Context.setClassShutter((ClassShutter)m_ClassShutter);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.m_Context.setApplicationClassLoader(Thread.currentThread().getContextClassLoader());
        this.m_UndefinedValue = Context.getUndefinedValue();
        this.m_Context.setOptimizationLevel(this.m_OptimizationLevel);
        this.m_Context.setErrorReporter(this.m_ErrorReporter);
        this.reset();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.m_ErrorReporter = errorReporter;
        this.m_Context.setErrorReporter(this.m_ErrorReporter);
    }

    public void reset() {
        this.m_ScriptableCache.clear();
        this.m_Scope = this.m_Global = new Global(this.m_Context);
        this.declareBean("Log", m_ExecLog);
        this.declareBean("Server", m_Server);
    }

    public Scriptable toScriptable(Object object) {
        Scriptable scriptable = this.m_ScriptableCache.get(object);
        if (scriptable == null) {
            scriptable = Context.toObject((Object)object, (Scriptable)this.m_Scope);
            Scriptable scriptable2 = this.m_Context.newObject(scriptable);
            scriptable2.setPrototype(scriptable);
            scriptable2.setParentScope(null);
            this.m_ScriptableCache.put(object, scriptable2);
            scriptable = scriptable2;
        }
        return scriptable;
    }

    public void pushScope() {
        Environment environment = new Environment();
        environment.setPrototype(this.m_Scope);
        this.pushScope((Scriptable)environment);
    }

    public void pushScope(Scriptable scriptable) {
        scriptable.setParentScope(this.m_Scope);
        this.m_Scope = scriptable;
    }

    public void popScope() {
        this.m_Scope = this.m_Scope.getParentScope();
    }

    public Scriptable getScope() {
        return this.m_Scope;
    }

    public void declareBean(String string, Object object) {
        Object object2 = null;
        object2 = object == null ? this.m_UndefinedValue : (object instanceof Scriptable ? object : Context.toObject((Object)object, (Scriptable)this.m_Scope));
        this.m_Global.put(string, this.m_Global, object2);
    }

    public void declareBean(String string, Object object, Class<?> clazz) {
        Object object2 = null;
        if (object != null && PrivilegedJavaProxy.shouldWrapWithDoPrivileged(clazz)) {
            object2 = PrivilegedJavaProxy.getProxy(clazz, object);
            this.declareBean(string, object2);
        } else {
            this.declareBean(string, object);
        }
    }

    public void undeclareBean(String string) {
        this.m_Global.delete(string);
    }

    public CompiledScript compile(String string, String string2) {
        return new CompiledScript(this.m_Context, this.m_Context.compileString(string2, string, 1, (Object)m_UserCodeSource));
    }

    public void validate(String string, String string2) {
        this.m_Context.compileString(string2, string, 1, (Object)m_UserCodeSource);
    }

    public Object call(String string, Object object, Object[] objectArray) throws ScriptException {
        try {
            Scriptable scriptable = null;
            scriptable = object instanceof Scriptable ? (Scriptable)object : Context.toObject((Object)object, (Scriptable)this.m_Scope);
            Function function = (Function)this.m_Scope.get(string, this.m_Scope);
            Object object2 = function.call(this.m_Context, this.m_Scope, scriptable, objectArray);
            if (object2 instanceof Wrapper) {
                object2 = ((Wrapper)object2).unwrap();
            }
            return object2;
        }
        catch (Exception exception) {
            throw new ScriptException("call error", exception);
        }
    }

    public void execute(String string, String string2) throws ScriptException {
        this.execute(string, string2, m_UserCodeSource);
    }

    public void execute(String string, String string2, CodeSource codeSource) throws ScriptException {
        try {
            this.m_Context.evaluateString(this.m_Scope, string2, "src", 1, (Object)codeSource);
        }
        catch (WrappedException wrappedException) {
            Throwable throwable = wrappedException.getCause();
            if (throwable instanceof JavaScriptException) {
                throw new ScriptException("Wrapped execute error", throwable);
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new ScriptException("Wrapped execute error", wrappedException);
        }
        catch (JavaScriptException javaScriptException) {
            throw new ScriptException("Execute error", javaScriptException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new ScriptException("Execute error", throwable);
        }
    }

    public Object evaluate(String string, String string2) throws ScriptException {
        return this.evaluate(string, string2, m_UserCodeSource);
    }

    public Object evaluate(String string, String string2, CodeSource codeSource) throws ScriptException {
        try {
            Object object = this.m_Context.evaluateString(this.m_Scope, string2, string, 1, (Object)codeSource);
            if (object instanceof Wrapper) {
                object = ((Wrapper)object).unwrap();
            }
            return object;
        }
        catch (JavaScriptException javaScriptException) {
            throw new ScriptException("Evaluate error", javaScriptException);
        }
        catch (WrappedException wrappedException) {
            Throwable throwable = wrappedException.getWrappedException();
            if (throwable instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (throwable instanceof TerminateException) {
                throw (TerminateException)throwable;
            }
            throw new ScriptException("Evaluate error", throwable);
        }
        catch (TerminateException terminateException) {
            throw terminateException;
        }
        catch (Throwable throwable) {
            throw new ScriptException("Evaluate error", throwable);
        }
    }

    public void setApplicationClassLoader(ClassLoader classLoader) {
        this.m_Context.setApplicationClassLoader(classLoader);
    }

    public void dispose() {
        this.m_ScriptableCache.clear();
    }

    public ElxLoggerJ getLog() {
        return m_Log;
    }

    public static void processFile(Context context, Scriptable scriptable, String string) {
        Reader reader = null;
        String string2 = string;
        if (URLUtil.isURL(string2)) {
            try {
                URL uRL = new URL(string2);
                InputStream inputStream = uRL.openStream();
                reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            }
            catch (IOException iOException) {
                m_Log.error((Object)("processFile(" + string2 + ") exception: " + iOException.toString()));
                return;
            }
        }
        if (reader == null) {
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8");
                string2 = new File(string2).getCanonicalPath();
            }
            catch (IOException iOException) {
                m_Log.error((Object)("processFile(" + string2 + ") exception: " + iOException.toString()));
                return;
            }
        }
        JavaScriptEngine.evaluateReader(context, scriptable, reader, string2, 1);
    }

    public static Object evaluateReader(Context context, Scriptable scriptable, Reader reader, String string, int n) {
        return JavaScriptEngine.evaluateReader(context, scriptable, reader, string, n, m_UserCodeSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluateReader(Context context, Scriptable scriptable, Reader reader, String string, int n, CodeSource codeSource) throws ThreadDeath {
        Object object = Context.getUndefinedValue();
        try {
            object = context.evaluateReader(scriptable, reader, string, n, (Object)codeSource);
        }
        catch (EcmaError ecmaError) {
            if (ecmaError.sourceName() != null) {
                m_Log.error((Object)("Uncaught exception: " + ecmaError.toString() + " in " + ecmaError.sourceName() + ":" + ecmaError.lineNumber() + ":" + ecmaError.columnNumber() + " (" + ecmaError.lineSource() + ")"));
            } else {
                m_Log.error((Object)("Uncaught exception: " + ecmaError.toString()));
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            m_Log.error((Object)("Exception: " + throwable.getMessage()));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                m_Log.error((Object)iOException.toString());
            }
        }
        return object;
    }

    public static Reader resolveScript(final String string) {
        if (m_Resolver != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Reader>(){

                @Override
                public Reader run() {
                    return m_Resolver.getReader(string);
                }
            });
        }
        return null;
    }

    public static void setResolver(IScriptResolver iScriptResolver) {
        m_Resolver = iScriptResolver;
    }

    public static CodeSource getSystemCodeSource() {
        return m_SystemCodeSource;
    }

    public static CodeSource getUserCodeSource() {
        return m_UserCodeSource;
    }

    public static SecurityController getSecurityController() {
        return m_SecurityController;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Scopes: ");
        for (Scriptable scriptable = this.m_Scope; scriptable != null; scriptable = scriptable.getParentScope()) {
            stringBuilder.append(scriptable);
        }
        return stringBuilder.toString();
    }

    static {
        try {
            m_UserCodeSource = new CodeSource(new URL(JAVASCRIPT_CODESOURCE_USER), new Certificate[0]);
            m_SystemCodeSource = new CodeSource(new URL(JAVASCRIPT_CODESOURCE_SYSTEM), new Certificate[0]);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        m_ClassShutter = new RepertoireClassShutter();
        m_ClassShutter.hideClass("com.elixirtech.arch.license.ILicense");
        m_ClassShutter.hideClass("com.elixirtech.arch.license.License");
        m_ClassShutter.hideClass("com.elixirtech.repository.SecureRepository");
        m_Resolver = new DefaultScriptResolver();
        m_Server = new ServerImpl();
        m_Log = ElxLoggerJ.getLogger(JavaScriptEngine.class);
        ElxLoggerJ elxLoggerJ = ElxLoggerJ.getLogger((String)"JavaScript.Execution");
        LoggerProxy loggerProxy = new LoggerProxy(elxLoggerJ);
        m_ExecLog = PrivilegedJavaProxy.getProxy(ILogger.class, loggerProxy);
    }

    private static class DefaultScriptResolver
    implements IScriptResolver {
        private DefaultScriptResolver() {
        }

        @Override
        public Reader getReader(String string) {
            RMLFileObject rMLFileObject;
            RMLRepository rMLRepository = (RMLRepository)Elixir.get(RMLRepository.class);
            if (rMLRepository != null && (rMLFileObject = rMLRepository.getFileJ(string)) != null) {
                try {
                    return new InputStreamReader(rMLFileObject.getInputStream(), "UTF-8");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

