/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.Range;
import java.awt.GridLayout;
import java.awt.event.AdjustmentEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxesPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 8959077427723505783L;
    private JSlider m_X;
    private JSlider m_Y;
    private JSlider m_Z;
    private JLabel m_Label;

    public AxesPanel(Range range, Range range2, Range range3) {
        this.setLayout(new GridLayout(4, 1));
        this.m_X = this.scroll("x", range);
        this.m_Y = this.scroll("y", range2);
        this.m_Z = this.scroll("z", range3);
        this.m_Label = new JLabel("(0,0,0)");
        this.add(this.m_Label);
    }

    public void setValues(int n, int n2, int n3) {
        this.m_X.setValue(n);
        this.m_Y.setValue(n2);
        this.m_Z.setValue(n3);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.m_X.getValue();
        int n2 = this.m_Y.getValue();
        int n3 = this.m_Z.getValue();
        this.m_Label.setText("(" + n + "," + n2 + "," + n3 + ")");
        this.firePropertyChange("value", null, new int[]{n, n2, n3});
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = this.m_X.getValue();
        int n2 = this.m_Y.getValue();
        int n3 = this.m_Z.getValue();
        this.m_Label.setText("(" + n + "," + n2 + "," + n3 + ")");
        this.firePropertyChange("value", null, new int[]{n, n2, n3});
    }

    private JSlider scroll(String string, Range range) {
        JSlider jSlider = new JSlider(0);
        jSlider.setName(string);
        jSlider.setMinimum(range.min);
        jSlider.setMaximum(range.max);
        jSlider.setValue(0);
        jSlider.addChangeListener(this);
        this.add(jSlider);
        return jSlider;
    }
}

