/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.Dependency2;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Matrix3d;
import com.elixirtech.limn.Object3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.RenderContext;
import com.elixirtech.limn.World;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Camera {
    protected ArrayOf3dPoints m_TempProjectionBuffer = new ArrayOf3dPoints(256);
    protected ArrayOf3dPoints m_TempWCSToVCSBuffer = new ArrayOf3dPoints(256);
    protected double m_ScreenDistance;
    protected int m_XOrigin;
    protected int m_YOrigin;
    protected int m_Width = 100;
    protected int m_Height = 100;
    protected double m_ViewAngle;
    Matrix3d m_WCStoVCSmatrix = new Matrix3d();
    Point3d m_WCSPosition = new Point3d();
    Angle3d m_Angle = new Angle3d();
    boolean m_MatrixIsDirty;
    protected World m_World;
    protected List<Object3d> m_VisibleObjects;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Camera.class);

    public Camera(World world, double d, Point3d point3d, Angle3d angle3d) {
        this.m_ViewAngle = d;
        this.calculateParameters();
        this.m_MatrixIsDirty = true;
        this.m_World = world;
        this.m_VisibleObjects = new ArrayList<Object3d>();
        this.setOrientation(point3d, angle3d);
    }

    public void setScreenSize(int n, int n2) {
        this.m_Width = n;
        this.m_Height = n2;
        this.calculateParameters();
    }

    private void calculateParameters() {
        this.m_XOrigin = this.m_Width >> 1;
        this.m_YOrigin = this.m_Height >> 1;
        this.m_ScreenDistance = -((double)this.m_XOrigin) / Math.tan(this.m_ViewAngle / 2.0);
    }

    public void setOrientation(Point3d point3d, Angle3d angle3d) {
        if (!this.m_WCSPosition.equals(point3d)) {
            this.m_WCSPosition.set(point3d);
            this.m_MatrixIsDirty = true;
        }
        if (!this.m_Angle.equals(angle3d)) {
            this.m_Angle.set(angle3d);
            this.m_MatrixIsDirty = true;
        }
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D rectangle2D = null;
        this.m_VisibleObjects.clear();
        this.m_World.getObjects(this.m_VisibleObjects);
        int n = this.m_VisibleObjects.size();
        RenderContext renderContext = new RenderContext(this, null);
        for (int i = 0; i < n; ++i) {
            Object3d object3d = this.m_VisibleObjects.get(i);
            Rectangle2D rectangle2D2 = object3d.getBoundingBox(renderContext);
            if (rectangle2D2 == null) continue;
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D.createUnion(rectangle2D2);
        }
        return rectangle2D;
    }

    public void paint(Graphics2D graphics2D) {
        m_Log.debug((Object)"paint-begin");
        Point3d point3d = this.m_World.getLight();
        RenderContext renderContext = new RenderContext(this, point3d);
        this.m_VisibleObjects.clear();
        this.m_World.getObjects(this.m_VisibleObjects);
        ArrayList<IndexingPolygon> arrayList = new ArrayList<IndexingPolygon>();
        for (Object3d object2 : this.m_VisibleObjects) {
            object2.update(renderContext);
            object2.buildPolygons(arrayList);
        }
        m_Log.debug((Object)("paint-built " + arrayList.size() + "polys"));
        List<IndexingPolygon> list = this.sortPolygons(arrayList);
        m_Log.debug((Object)("paint-sorted " + list.size() + "polys"));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IndexingPolygon indexingPolygon = (IndexingPolygon)iterator.next();
            indexingPolygon.paint(graphics2D, renderContext);
        }
        m_Log.debug((Object)"paint-end");
    }

    private List<IndexingPolygon> sortPolygons(List<IndexingPolygon> list) {
        List<IndexingPolygon> list2 = Dependency2.order(list);
        return list2;
    }

    public ArrayOf3dPoints project(ArrayOf3dPoints arrayOf3dPoints) {
        this.doTransform(arrayOf3dPoints, this.m_TempWCSToVCSBuffer);
        this.doProjection(this.m_TempWCSToVCSBuffer, this.m_TempProjectionBuffer);
        return this.m_TempProjectionBuffer;
    }

    protected void doTransform(ArrayOf3dPoints arrayOf3dPoints, ArrayOf3dPoints arrayOf3dPoints2) {
        this.updateMatrix();
        this.m_WCStoVCSmatrix.transform(arrayOf3dPoints, arrayOf3dPoints2);
        arrayOf3dPoints2.npoints = arrayOf3dPoints.npoints;
    }

    protected void doProjection(ArrayOf3dPoints arrayOf3dPoints, ArrayOf3dPoints arrayOf3dPoints2) {
        for (int i = 0; i < arrayOf3dPoints.npoints; ++i) {
            double d = arrayOf3dPoints.z[i];
            arrayOf3dPoints2.x[i] = (int)(this.m_ScreenDistance * arrayOf3dPoints.x[i] / d) + this.m_XOrigin;
            arrayOf3dPoints2.y[i] = -((int)(this.m_ScreenDistance * arrayOf3dPoints.y[i] / d)) + this.m_YOrigin;
            arrayOf3dPoints2.z[i] = d;
        }
        arrayOf3dPoints2.npoints = arrayOf3dPoints.npoints;
    }

    public void updateMatrix() {
        if (this.m_MatrixIsDirty) {
            this.m_WCStoVCSmatrix.makeWCStoVCStransform(this.m_WCSPosition, this.m_Angle);
            this.m_MatrixIsDirty = false;
        }
    }
}

