/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

public class Point3d {
    public double x;
    public double y;
    public double z;

    public Point3d(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Point3d() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Point3d(Point3d point3d, Point3d point3d2) {
        this.x = point3d2.x - point3d.x;
        this.y = point3d2.y - point3d.y;
        this.z = point3d2.z - point3d.z;
    }

    public Point3d(Point3d point3d) {
        this.x = point3d.x;
        this.y = point3d.y;
        this.z = point3d.z;
    }

    public void makeVectorTo(Point3d point3d) {
        this.x = point3d.x - this.x;
        this.y = point3d.y - this.y;
        this.z = point3d.z - this.z;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Point3d makeClone() {
        return new Point3d(this.x, this.y, this.z);
    }

    public void plus(double d) {
        this.x += d;
        this.y += d;
        this.z += d;
    }

    public double distanceToPoint2(Point3d point3d) {
        double d = point3d.x - this.x;
        double d2 = point3d.y - this.y;
        double d3 = point3d.z - this.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    public void rotateAboutYaxis(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d2 * this.x + d3 * this.z;
        double d5 = -d3 * this.x + d2 * this.z;
        this.x = d4;
        this.z = d5;
    }

    public void rotateAboutXaxis(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d2 * this.y - d3 * this.z;
        double d5 = d3 * this.y + d2 * this.z;
        this.y = d4;
        this.z = d5;
    }

    public void rotateAboutZaxis(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = d2 * this.x - d3 * this.y;
        double d5 = d3 * this.x + d2 * this.y;
        this.x = d4;
        this.y = d5;
    }

    public void rotateAboutAxis(Point3d point3d, double d) {
        Point3d point3d2 = point3d.makeClone();
        double d2 = Math.atan2(point3d2.z, point3d2.x);
        point3d2.rotateAboutYaxis(-d2);
        double d3 = Math.atan2(point3d2.y, point3d2.x);
        this.rotateAboutYaxis(-d2);
        this.rotateAboutZaxis(-d3);
        this.rotateAboutXaxis(d);
        this.rotateAboutZaxis(d3);
        this.rotateAboutYaxis(d2);
    }

    public void reflectInXYPlane() {
        this.z = -this.z;
    }

    public void reflectInYZPlane() {
        this.x = -this.x;
    }

    public void reflectInXZPlane() {
        this.y = -this.y;
    }

    public void reflectAroundVector(Point3d point3d) {
        double d = Math.atan2(point3d.y, point3d.x);
        this.rotateAboutZaxis(-d);
        double d2 = Math.atan2(point3d.x, point3d.z);
        this.rotateAboutYaxis(-d2);
        this.reflectInYZPlane();
        this.rotateAboutYaxis(d2);
        this.rotateAboutZaxis(d);
    }

    public double maxComponent() {
        return Math.max(Math.max(this.x, this.y), this.z);
    }

    public void vectorProduct(Point3d point3d, Point3d point3d2) {
        this.x = point3d.y * point3d2.z - point3d.z * point3d2.y;
        this.y = point3d.z * point3d2.x - point3d.x * point3d2.z;
        this.z = point3d.x * point3d2.y - point3d.y * point3d2.x;
    }

    public void normalize(double d) {
        double d2 = d / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x = d2 * this.x;
        this.y = d2 * this.y;
        this.z = d2 * this.z;
    }

    public void plus(Point3d point3d) {
        this.x += point3d.x;
        this.y += point3d.y;
        this.z += point3d.z;
    }

    public void plus(Point3d point3d, double d) {
        this.x += point3d.x * d;
        this.y += point3d.y * d;
        this.z += point3d.z * d;
    }

    public double dotProduct(Point3d point3d) {
        return point3d.x * this.x + point3d.y * this.y + point3d.z * this.z;
    }

    public boolean equals(Object object) {
        if (object instanceof Point3d) {
            Point3d point3d = (Point3d)object;
            return point3d.x == this.x && point3d.y == this.y && point3d.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        return Double.valueOf(this.x).hashCode() ^ Double.valueOf(this.y).hashCode() ^ Double.valueOf(this.z).hashCode();
    }

    public void set(Point3d point3d) {
        this.x = point3d.x;
        this.y = point3d.y;
        this.z = point3d.z;
    }

    public void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void times(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }
}

