/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Plane;
import com.elixirtech.limn.RangeD;
import java.awt.Polygon;
import java.awt.geom.Area;

public class PolygonSorter {
    public static final int BEHIND = -1;
    public static final int AHEAD = 1;
    public static final int DONT_CARE = 0;
    public static final int CONTINUE = 2;

    public static int sort(IndexingPolygon indexingPolygon, IndexingPolygon indexingPolygon2) {
        if (indexingPolygon.getSerial() < indexingPolygon2.getSerial()) {
            return PolygonSorter.sortOrdered(indexingPolygon, indexingPolygon2);
        }
        int n = PolygonSorter.sortOrdered(indexingPolygon2, indexingPolygon);
        if (n == 1) {
            return -1;
        }
        if (n == -1) {
            return 1;
        }
        return n;
    }

    public static int sortOrdered(IndexingPolygon indexingPolygon, IndexingPolygon indexingPolygon2) {
        if (PolygonSorter.isTesting(indexingPolygon) && PolygonSorter.isTesting(indexingPolygon2)) {
            int n = PolygonSorter.doSortOrdered(indexingPolygon, indexingPolygon2);
            System.out.println("Sorting " + indexingPolygon + " with " + indexingPolygon2 + " gives " + PolygonSorter.name(n));
            return n;
        }
        return PolygonSorter.doSortOrdered(indexingPolygon, indexingPolygon2);
    }

    private static boolean isTesting(IndexingPolygon indexingPolygon) {
        return indexingPolygon.getId() != null && indexingPolygon.getId().startsWith("**");
    }

    private static String name(int n) {
        if (n == -1) {
            return "Behind";
        }
        if (n == 1) {
            return "Ahead";
        }
        if (n == 0) {
            return "DontCare";
        }
        if (n == 2) {
            return "Continue";
        }
        return "Unknown: " + n;
    }

    private static int doSortOrdered(IndexingPolygon indexingPolygon, IndexingPolygon indexingPolygon2) {
        RangeD[] rangeDArray;
        RangeD[] rangeDArray2 = indexingPolygon.getRange();
        if (!rangeDArray2[1].intersects((rangeDArray = indexingPolygon2.getRange())[1])) {
            return 0;
        }
        if (!rangeDArray2[0].intersects(rangeDArray[0])) {
            return 0;
        }
        if (!rangeDArray2[2].intersects(rangeDArray[2])) {
            return rangeDArray2[2].min < rangeDArray[2].min ? -1 : 1;
        }
        Polygon polygon = new Polygon();
        Polygon polygon2 = new Polygon();
        indexingPolygon.buildPolygon(polygon);
        indexingPolygon2.buildPolygon(polygon2);
        Area area = new Area(polygon);
        Area area2 = new Area(polygon2);
        area.intersect(area2);
        if (area.isEmpty()) {
            return 0;
        }
        Plane plane = indexingPolygon.getPlane();
        Plane plane2 = indexingPolygon2.getPlane();
        ArrayOf3dPoints arrayOf3dPoints = indexingPolygon.getViewPoints();
        ArrayOf3dPoints arrayOf3dPoints2 = indexingPolygon2.getViewPoints();
        int n = PolygonSorter.getSide(plane, arrayOf3dPoints2);
        if (n == 0) {
            return 0;
        }
        int n2 = PolygonSorter.getSide(plane2, arrayOf3dPoints);
        if (n == n2) {
            return 0;
        }
        if (n == -1) {
            return -1;
        }
        if (n == 1) {
            return 1;
        }
        if (n2 == -1) {
            return 1;
        }
        if (n2 == 1) {
            return -1;
        }
        return n;
    }

    private static int getSide(Plane plane, ArrayOf3dPoints arrayOf3dPoints) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < arrayOf3dPoints.npoints; ++i) {
            double d = plane.getSide(arrayOf3dPoints.x[i], arrayOf3dPoints.y[i], arrayOf3dPoints.z[i]);
            if (d < -1.0E-5) {
                ++n;
                continue;
            }
            if (!(d > 1.0E-5)) continue;
            ++n2;
        }
        if (n > 0 && n2 == 0) {
            return -1;
        }
        if (n2 > 0 && n == 0) {
            return 1;
        }
        if (n == 0 && n2 == 0) {
            return 0;
        }
        return 2;
    }
}

