/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Polyhedron;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.ShadedColor;

public class Primitives {
    static final double[][] CUBE_ORIGIN_PTS = new double[][]{{1.0, 1.0, 1.0}, {0.0, 1.0, 1.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 0.0}, {1.0, 0.0, 0.0}};
    static final double[][] CUBE_PTS = new double[][]{{1.0, 1.0, 1.0}, {-1.0, 1.0, 1.0}, {-1.0, -1.0, 1.0}, {1.0, -1.0, 1.0}, {1.0, 1.0, -1.0}, {-1.0, 1.0, -1.0}, {-1.0, -1.0, -1.0}, {1.0, -1.0, -1.0}};
    static final double[][] SIDE_PTS = new double[][]{{100.0, 100.0, 1.0}, {-100.0, 100.0, 1.0}, {-100.0, -100.0, 1.0}, {100.0, -100.0, 1.0}, {100.0, 100.0, -1.0}, {-100.0, 100.0, -1.0}, {-100.0, -100.0, -1.0}, {100.0, -100.0, -1.0}};
    static final int[][] CUBE_SIDES = new int[][]{{2, 1, 0, 3}, {2, 3, 7, 6}, {3, 0, 4, 7}, {0, 1, 5, 4}, {1, 2, 6, 5}, {7, 4, 5, 6}};

    public static Polyhedron cube(ShadedColor shadedColor) {
        int n = CUBE_PTS.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = CUBE_PTS[i][0];
            dArray2[i] = CUBE_PTS[i][1];
            dArray3[i] = CUBE_PTS[i][2];
        }
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray, dArray2, dArray3, 8);
        int n2 = CUBE_SIDES.length;
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[n2];
        for (int i = 0; i < n2; ++i) {
            indexingPolygonArray[i] = new RenderedPolygon(CUBE_SIDES[i], shadedColor);
            indexingPolygonArray[i].setId(String.valueOf(i));
        }
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        return polyhedron;
    }

    public static Polyhedron renderedCube(ShadedColor shadedColor) {
        int n = CUBE_PTS.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = CUBE_PTS[i][0];
            dArray2[i] = CUBE_PTS[i][1];
            dArray3[i] = CUBE_PTS[i][2];
        }
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray, dArray2, dArray3, 8);
        int n2 = CUBE_SIDES.length;
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[n2];
        for (int i = 0; i < n2; ++i) {
            indexingPolygonArray[i] = new RenderedPolygon(CUBE_SIDES[i], shadedColor);
            indexingPolygonArray[i].setId(String.valueOf(i));
        }
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        return polyhedron;
    }

    public static Polyhedron renderedSheet(ShadedColor shadedColor) {
        double[] dArray = new double[]{0.0, 0.0, 1.0, 1.0};
        double[] dArray2 = new double[]{0.0, 1.0, 1.0, 0.0};
        double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0};
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray, dArray2, dArray3, 4);
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[]{new RenderedPolygon("0", new int[]{0, 1, 2, 3}, shadedColor)};
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        return polyhedron;
    }

    public static Polyhedron renderedCubeOrigin(ShadedColor shadedColor) {
        int n = CUBE_ORIGIN_PTS.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = CUBE_ORIGIN_PTS[i][0];
            dArray2[i] = CUBE_ORIGIN_PTS[i][1];
            dArray3[i] = CUBE_ORIGIN_PTS[i][2];
        }
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray, dArray2, dArray3, 8);
        int n2 = CUBE_SIDES.length;
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[n2];
        for (int i = 0; i < n2; ++i) {
            indexingPolygonArray[i] = new RenderedPolygon(CUBE_SIDES[i], shadedColor);
            indexingPolygonArray[i].setId(String.valueOf(i));
        }
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        return polyhedron;
    }

    public static Polyhedron renderedBox(int n, int n2, int n3, ShadedColor shadedColor) {
        double[] dArray = new double[8];
        double[] dArray2 = new double[8];
        double[] dArray3 = new double[8];
        dArray[0] = 0.0;
        dArray2[0] = 0.0;
        dArray3[0] = 0.0;
        dArray[1] = 0.0;
        dArray2[1] = n2;
        dArray3[1] = 0.0;
        dArray[2] = n;
        dArray2[2] = n2;
        dArray3[2] = 0.0;
        dArray[3] = n;
        dArray2[3] = 0.0;
        dArray3[3] = 0.0;
        dArray[4] = 0.0;
        dArray2[4] = 0.0;
        dArray3[4] = n3;
        dArray[5] = 0.0;
        dArray2[5] = n2;
        dArray3[5] = n3;
        dArray[6] = n;
        dArray2[6] = n2;
        dArray3[6] = n3;
        dArray[7] = n;
        dArray2[7] = 0.0;
        dArray3[7] = n3;
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray, dArray2, dArray3, 8);
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[]{new RenderedPolygon(new int[]{0, 1, 5, 4}, shadedColor), new RenderedPolygon(new int[]{1, 2, 6, 5}, shadedColor), new RenderedPolygon(new int[]{2, 3, 7, 6}, shadedColor), new RenderedPolygon(new int[]{3, 0, 4, 7}, shadedColor), new RenderedPolygon(new int[]{2, 1, 0, 3}, shadedColor), new RenderedPolygon(new int[]{4, 5, 6, 7}, shadedColor)};
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        return polyhedron;
    }

    public static Polyhedron renderedSide(ShadedColor shadedColor) {
        return Primitives.renderedBox(200, 200, 2, shadedColor);
    }

    public static Polyhedron renderedValue(double[] dArray, int n, int n2, int n3, ShadedColor shadedColor) {
        int n4;
        int n5 = dArray.length * 4;
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n5];
        double[] dArray4 = new double[n5];
        int n6 = 0;
        double d = (double)n2 / 2.0;
        double d2 = (double)n / 2.0;
        for (int i = 0; i < dArray.length; ++i) {
            n4 = i * 4;
            dArray2[n4] = n6;
            dArray2[n4 + 1] = n6;
            dArray2[n4 + 2] = n6;
            dArray2[n4 + 3] = n6;
            n6 += n3;
            dArray3[n4] = dArray[i] - d;
            dArray3[n4 + 1] = dArray[i] + d;
            dArray3[n4 + 2] = dArray[i] + d;
            dArray3[n4 + 3] = dArray[i] - d;
            dArray4[n4] = d2;
            dArray4[n4 + 1] = d2;
            dArray4[n4 + 2] = -d2;
            dArray4[n4 + 3] = -d2;
        }
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray2, dArray3, dArray4, n5);
        n4 = n5 - 2;
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[n4];
        for (int i = 0; i < dArray.length - 1; ++i) {
            int n7 = i * 4;
            indexingPolygonArray[n7] = new RenderedPolygon(n7 + "-0", new int[]{n7, n7 + 1, n7 + 5, n7 + 4}, shadedColor);
            indexingPolygonArray[n7 + 1] = new RenderedPolygon(n7 + "-1", new int[]{n7 + 1, n7 + 2, n7 + 6, n7 + 5}, shadedColor);
            indexingPolygonArray[n7 + 2] = new RenderedPolygon(n7 + "-2", new int[]{n7 + 2, n7 + 3, n7 + 7, n7 + 6}, shadedColor);
            indexingPolygonArray[n7 + 3] = new RenderedPolygon(n7 + "-3", new int[]{n7 + 3, n7, n7 + 4, n7 + 7}, shadedColor);
        }
        indexingPolygonArray[n4 - 2] = new RenderedPolygon("start", new int[]{0, 3, 2, 1}, shadedColor);
        indexingPolygonArray[n4 - 1] = new RenderedPolygon("end", new int[]{n5 - 1, n5 - 4, n5 - 3, n5 - 2}, shadedColor);
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        return polyhedron;
    }

    public static Polyhedron buildValue(double d, double d2, int n, int n2, int n3, int n4, ShadedColor shadedColor) {
        double d3 = (double)n2 / 2.0;
        double d4 = (double)n / 2.0;
        double[] dArray = new double[8];
        double[] dArray2 = new double[8];
        double[] dArray3 = new double[8];
        dArray[2] = dArray[3] = (double)n3;
        dArray[1] = dArray[3];
        dArray[0] = dArray[3];
        dArray[6] = dArray[7] = (double)(n3 + n4);
        dArray[5] = dArray[7];
        dArray[4] = dArray[7];
        dArray2[0] = d - d3;
        dArray2[1] = d + d3;
        dArray2[2] = d + d3;
        dArray2[3] = d - d3;
        dArray2[4] = d2 - d3;
        dArray2[5] = d2 + d3;
        dArray2[6] = d2 + d3;
        dArray2[7] = d2 - d3;
        dArray3[0] = d4;
        dArray3[1] = d4;
        dArray3[2] = -d4;
        dArray3[3] = -d4;
        dArray3[4] = d4;
        dArray3[5] = d4;
        dArray3[6] = -d4;
        dArray3[7] = -d4;
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray, dArray2, dArray3, 8);
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[]{new RenderedPolygon(new int[]{0, 1, 5, 4}, shadedColor), new RenderedPolygon(new int[]{1, 2, 6, 5}, shadedColor), new RenderedPolygon(new int[]{2, 3, 7, 6}, shadedColor), new RenderedPolygon(new int[]{3, 0, 4, 7}, shadedColor), new RenderedPolygon(new int[]{2, 1, 0, 3}, shadedColor), new RenderedPolygon(new int[]{4, 5, 6, 7}, shadedColor)};
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        return polyhedron;
    }
}

