/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import java.awt.Color;

public class ShadedColor {
    private final int m_R;
    private final int m_G;
    private final int m_B;
    private final int m_A;
    private Color m_BaseColor;

    public ShadedColor(Color color) {
        this.m_R = color.getRed();
        this.m_G = color.getGreen();
        this.m_B = color.getBlue();
        this.m_A = color.getAlpha();
        this.m_BaseColor = color;
    }

    public ShadedColor(int n, int n2, int n3) {
        this(n, n2, n3, 255);
    }

    public ShadedColor(int n, int n2, int n3, int n4) {
        this.m_R = n;
        this.m_G = n2;
        this.m_B = n3;
        this.m_A = n4;
        this.m_BaseColor = new Color(this.m_R, this.m_G, this.m_B, this.m_A);
    }

    public boolean isTranslucent() {
        return this.m_A < 255;
    }

    public void setIntensity(double d) {
        int n = (int)(d * 64.0);
        int n2 = this.m_R + n;
        int n3 = this.m_G + n;
        int n4 = this.m_B + n;
        if (n2 > 255) {
            n2 = 255;
        } else if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        } else if (n3 < 0) {
            n3 = 0;
        }
        if (n4 > 255) {
            n4 = 255;
        } else if (n4 < 0) {
            n4 = 0;
        }
        this.m_BaseColor = new Color(n2, n3, n4, this.m_A);
    }

    public Color getColor() {
        return this.m_BaseColor;
    }

    public ShadedColor makeClone() {
        return new ShadedColor(this.m_R, this.m_G, this.m_B, this.m_A);
    }

    public String toString() {
        return "(" + this.m_R + "," + this.m_G + "," + this.m_B + "," + this.m_A + ") -> (" + this.m_BaseColor.getRed() + "," + this.m_BaseColor.getGreen() + "," + this.m_BaseColor.getBlue() + ") ";
    }
}

