/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn.chart;

import com.elixirtech.limn.chart.IAxisValues;
import java.text.NumberFormat;
import java.util.ArrayList;

public class NumberAxisValues
implements IAxisValues {
    private double m_Minimum;
    private double m_Maximum;
    private int m_Magnitude;
    private double[] m_Keys;
    private IAxisValues.Position[] m_Positions;
    private boolean m_StartAtZero;
    private double m_StartValue;
    private double m_StopValue;
    private NumberFormat m_Format;
    private boolean m_ShowLabels;
    private boolean m_ShowAxis = true;
    private double m_PaddingOffset;
    private double m_PaddingScale = 1.0;
    private boolean m_PositionsDirty;

    public NumberAxisValues(Object[] objectArray, boolean bl, boolean bl2) {
        this.m_Keys = new double[objectArray.length];
        this.m_StartAtZero = bl;
        this.m_ShowLabels = bl2;
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_Keys[i] = objectArray[i] != null ? ((Number)objectArray[i]).doubleValue() : 0.0;
        }
        this.construct();
        this.m_PositionsDirty = true;
    }

    public NumberAxisValues(Number[] numberArray, boolean bl, boolean bl2) {
        this.m_Keys = new double[numberArray.length];
        this.m_StartAtZero = bl;
        this.m_ShowLabels = bl2;
        for (int i = 0; i < numberArray.length; ++i) {
            this.m_Keys[i] = numberArray[i] != null ? numberArray[i].doubleValue() : 0.0;
        }
        this.construct();
        this.m_PositionsDirty = true;
    }

    public NumberAxisValues(double[] dArray, boolean bl, boolean bl2) {
        this.m_Keys = dArray;
        this.m_StartAtZero = bl;
        this.m_ShowLabels = bl2;
        this.construct();
        this.m_PositionsDirty = true;
    }

    public void setShowLabels(boolean bl) {
        this.m_ShowLabels = bl;
    }

    public void setShowAxis(boolean bl) {
        this.m_ShowAxis = bl;
    }

    public void setFormat(NumberFormat numberFormat) {
        this.m_Format = numberFormat;
        this.m_PositionsDirty = true;
    }

    public void setPaddingPercent(int n) {
        this.m_PaddingOffset = (double)n / 100.0;
        this.m_PaddingScale = 1.0 - (double)n / 50.0;
    }

    public NumberAxisValues makeClone() {
        NumberAxisValues numberAxisValues = new NumberAxisValues();
        numberAxisValues.m_Minimum = this.m_Minimum;
        numberAxisValues.m_Maximum = this.m_Maximum;
        numberAxisValues.m_Magnitude = this.m_Magnitude;
        numberAxisValues.m_Keys = this.m_Keys;
        numberAxisValues.m_Positions = this.m_Positions;
        numberAxisValues.m_StartAtZero = this.m_StartAtZero;
        numberAxisValues.m_StartValue = this.m_StartValue;
        numberAxisValues.m_StopValue = this.m_StopValue;
        numberAxisValues.m_Format = this.m_Format;
        numberAxisValues.m_ShowLabels = this.m_ShowLabels;
        numberAxisValues.m_ShowAxis = this.m_ShowAxis;
        numberAxisValues.m_PaddingOffset = this.m_PaddingOffset;
        numberAxisValues.m_PaddingScale = this.m_PaddingScale;
        numberAxisValues.m_PositionsDirty = this.m_PositionsDirty;
        return numberAxisValues;
    }

    @Override
    public double getStepSize() {
        if (this.m_Keys.length == 0) {
            return 0.5;
        }
        return 1.0 / (double)this.m_Keys.length;
    }

    protected NumberAxisValues() {
    }

    protected double getStartValue() {
        return this.m_StartValue;
    }

    protected double getStopValue() {
        return this.m_StopValue;
    }

    public void construct() {
        if (this.m_Keys.length > 0) {
            this.m_Minimum = this.m_Keys[0];
            this.m_Maximum = this.m_Keys[0];
            for (int i = 1; i < this.m_Keys.length; ++i) {
                if (this.m_Keys[i] < this.m_Minimum) {
                    this.m_Minimum = this.m_Keys[i];
                    continue;
                }
                if (!(this.m_Keys[i] > this.m_Maximum)) continue;
                this.m_Maximum = this.m_Keys[i];
            }
        }
        this.calculateRange();
    }

    @Override
    public int getPositionCount() {
        if (this.m_PositionsDirty) {
            this.calculatePositions();
        }
        return this.m_Positions.length;
    }

    @Override
    public IAxisValues.Position getPosition(int n) {
        if (this.m_PositionsDirty) {
            this.calculatePositions();
        }
        return this.m_Positions[n];
    }

    @Override
    public double getLocation(Object object) {
        if (this.m_StopValue == this.m_StartValue) {
            return 0.0;
        }
        double d = ((Number)object).doubleValue();
        double d2 = (d - this.m_StartValue) / (this.m_StopValue - this.m_StartValue);
        if (this.m_PaddingOffset > 0.0) {
            d2 = this.m_PaddingOffset + d2 * this.m_PaddingScale;
        }
        return d2;
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    @Override
    public boolean isShowTickLabels() {
        return this.m_ShowLabels;
    }

    @Override
    public boolean isShowAxis() {
        return this.m_ShowAxis;
    }

    private void calculateRange() {
        this.m_Magnitude = Math.max(this.calcMagnitude(this.m_Minimum), this.calcMagnitude(this.m_Maximum));
        this.m_StartValue = this.m_Minimum > 0.0 && this.m_StartAtZero ? 0.0 : this.roundDown(this.m_Minimum, this.m_Magnitude);
        this.m_StopValue = this.roundUp(this.m_Maximum, this.m_Magnitude);
    }

    private void calculatePositions() {
        double d;
        double d2 = 1.0;
        if (this.m_Magnitude > 0) {
            for (var3_2 = 0; var3_2 < this.m_Magnitude; ++var3_2) {
                d2 *= 10.0;
            }
        } else {
            for (var3_2 = 0; var3_2 > this.m_Magnitude; --var3_2) {
                d2 /= 10.0;
            }
        }
        if ((d = (this.m_StopValue - this.m_StartValue) / d2) < 4.0) {
            d2 /= 2.0;
            --this.m_Magnitude;
        }
        ArrayList<IAxisValues.Position> arrayList = new ArrayList<IAxisValues.Position>();
        arrayList.add(new IAxisValues.Position(this.formatValue(this.m_StartValue), 0.0));
        double d3 = this.m_StartValue;
        while (d3 < this.m_StopValue) {
            double d4 = this.roundDown(d3 += d2, this.m_Magnitude);
            double d5 = (d4 - this.m_StartValue) / (this.m_StopValue - this.m_StartValue);
            arrayList.add(new IAxisValues.Position(this.formatValue(d4), d5));
        }
        arrayList.add(new IAxisValues.Position(this.formatValue(this.m_StopValue), 1.0));
        this.m_Positions = new IAxisValues.Position[arrayList.size()];
        arrayList.toArray(this.m_Positions);
        if (this.m_PaddingOffset > 0.0) {
            this.applyPositionPadding();
        }
        this.m_PositionsDirty = false;
    }

    private void applyPositionPadding() {
        for (int i = 0; i < this.m_Positions.length; ++i) {
            double d = this.m_Positions[i].location;
            this.m_Positions[i].location = this.m_PaddingOffset + d * this.m_PaddingScale;
        }
    }

    private int calcMagnitude(double d) {
        if (d == 0.0) {
            return 0;
        }
        int n = 0;
        double d2 = Math.abs(d);
        if (d2 < 1.0) {
            while (d2 < 1.0) {
                d2 *= 10.0;
                --n;
            }
        } else {
            while (d2 > 10.0) {
                d2 /= 10.0;
                ++n;
            }
        }
        return n;
    }

    private String formatValue(double d) {
        if (this.m_Format == null) {
            this.initFormat();
        }
        return this.m_Format.format(d);
    }

    private void initFormat() {
        this.m_Format = NumberFormat.getNumberInstance();
        this.m_Format.setGroupingUsed(true);
        this.m_Format.setMaximumFractionDigits(this.m_Magnitude < 0 ? -this.m_Magnitude : 0);
    }

    private double roundDown(double d, int n) {
        int n2;
        double d2 = d;
        if (n < 0) {
            int n3;
            for (n3 = 0; n3 > n; --n3) {
                d2 *= 10.0;
            }
            d2 = Math.floor(d2);
            for (n3 = 0; n3 > n; --n3) {
                d2 /= 10.0;
            }
            return d2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            d2 /= 10.0;
        }
        d2 = Math.floor(d2);
        for (n2 = 0; n2 < n; ++n2) {
            d2 *= 10.0;
        }
        return d2;
    }

    private double roundUp(double d, int n) {
        int n2;
        double d2 = d;
        if (n < 0) {
            int n3;
            for (n3 = 0; n3 > n; --n3) {
                d2 *= 10.0;
            }
            d2 = Math.ceil(d2);
            for (n3 = 0; n3 > n; --n3) {
                d2 /= 10.0;
            }
            return d2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            d2 /= 10.0;
        }
        d2 = Math.ceil(d2);
        for (n2 = 0; n2 < n; ++n2) {
            d2 *= 10.0;
        }
        return d2;
    }

    public String toString() {
        return "NumberAxisValues(min=" + this.m_Minimum + ",max=" + this.m_Maximum + ",start=" + this.m_StartValue + ",stop=" + this.m_StopValue + ",padOff=" + this.m_PaddingOffset + ",padScale=" + this.m_PaddingScale;
    }
}

