/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn.chart;

import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.Line3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.RenderContext;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.Util;
import com.elixirtech.limn.chart.AbstractAxisOverlay;
import com.elixirtech.limn.chart.ChartWorld;
import com.elixirtech.limn.chart.IAxisValues;
import com.elixirtech.limn.chart.Label;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RightAxisOverlay
extends AbstractAxisOverlay {
    public static final int TICK_GAP = 10;
    public static final int LABEL_GAP = 30;
    private IAxisValues m_AxisValues;
    private Color m_GridColor = Color.gray;
    private Color m_TickLabelColor = Color.blue;
    private Font m_TickLabelFont = ChartWorld.DEFAULT_LABEL_FONT;
    private String m_Label;
    private Color m_LabelColor = Color.black;
    private Font m_LabelFont = ChartWorld.DEFAULT_LABEL_FONT;

    public RightAxisOverlay(IAxisValues iAxisValues) {
        this.m_AxisValues = iAxisValues;
    }

    public void setTickUi(Color color, Color color2, Font font) {
        this.m_GridColor = color;
        this.m_TickLabelColor = color2;
        this.m_TickLabelFont = font;
    }

    public void setLabelUi(String string, Color color, Font font) {
        this.m_Label = string;
        this.m_LabelColor = color;
        this.m_LabelFont = font;
    }

    @Override
    public void buildLabels(RenderContext renderContext, ArrayOf3dPoints arrayOf3dPoints, List<Label> list) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (!this.m_AxisValues.isShowAxis()) {
            return;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        Line3d line3d = new Line3d(arrayOf3dPoints.getPoint(5), arrayOf3dPoints.getPoint(4));
        FontRenderContext fontRenderContext = renderContext.getFontRenderContext();
        if (this.m_AxisValues.isShowTickLabels()) {
            object5 = new Line3d(arrayOf3dPoints.getPoint(0), arrayOf3dPoints.getPoint(5));
            object4 = new Line3d(arrayOf3dPoints.getPoint(3), arrayOf3dPoints.getPoint(4));
            object3 = ((Line3d)object5).extend(10.0);
            object2 = ((Line3d)object4).extend(10.0);
            object = new Line3d((Point3d)object3, (Point3d)object2);
            int n = this.m_AxisValues.getPositionCount();
            for (int i = 0; i < n; ++i) {
                IAxisValues.Position position = this.m_AxisValues.getPosition(i);
                double d = position.location * 100.0;
                Point3d point3d = ((Line3d)object).position(d);
                ArrayOf3dPoints arrayOf3dPoints2 = new ArrayOf3dPoints(1);
                arrayOf3dPoints2.setPoint(0, point3d.x, point3d.y, point3d.z);
                ArrayOf3dPoints arrayOf3dPoints3 = renderContext.project(arrayOf3dPoints2);
                Point point = new Point(new Point((int)arrayOf3dPoints3.x[0], (int)arrayOf3dPoints3.y[0]));
                Label label = new Label(position.label, point, 1, 4, this.m_TickLabelColor, this.m_TickLabelFont);
                arrayList.add(label.getBoundingBox(fontRenderContext));
                list.add(label);
            }
        }
        if (Util.notEmpty(this.m_Label)) {
            object5 = line3d.position(50.0);
            if (arrayList.size() > 0) {
                object4 = new ArrayOf3dPoints(1);
                ((ArrayOf3dPoints)object4).setPoint(0, ((Point3d)object5).x, ((Point3d)object5).y, ((Point3d)object5).z);
                object3 = renderContext.project((ArrayOf3dPoints)object4);
                object2 = new Point((int)((ArrayOf3dPoints)object3).x[0] + 30, (int)((ArrayOf3dPoints)object3).y[0]);
                object = new Label(this.m_Label, (Point)object2, 2, 5, this.m_LabelColor, this.m_LabelFont);
                Rectangle2D rectangle2D = ((Label)object).getBoundingBox(fontRenderContext);
                while (this.intersects(rectangle2D, arrayList)) {
                    ((Label)object).offsetX(5);
                    rectangle2D = ((Label)object).getBoundingBox(fontRenderContext);
                }
                list.add((Label)object);
            } else {
                object4 = arrayOf3dPoints.getPoint(4);
                object3 = new ArrayOf3dPoints(2);
                ((ArrayOf3dPoints)object3).setPoint(0, ((Point3d)object5).x, ((Point3d)object5).y, ((Point3d)object5).z);
                ((ArrayOf3dPoints)object3).setPoint(1, ((Point3d)object4).x, ((Point3d)object4).y, ((Point3d)object4).z);
                object2 = renderContext.project((ArrayOf3dPoints)object3);
                object = new Point((int)((ArrayOf3dPoints)object2).x[1] + 30, (int)((ArrayOf3dPoints)object2).y[0]);
                Label label = new Label(this.m_Label, (Point)object, 2, 6, this.m_LabelColor, this.m_LabelFont);
                list.add(label);
            }
        }
    }

    @Override
    public void render(Graphics2D graphics2D, RenderContext renderContext, RenderedPolygon renderedPolygon, Polygon polygon) {
        ArrayOf3dPoints arrayOf3dPoints = renderedPolygon.getPolyhedron().getVertices();
        Line3d line3d = new Line3d(arrayOf3dPoints.getPoint(0), arrayOf3dPoints.getPoint(3));
        Line3d line3d2 = new Line3d(arrayOf3dPoints.getPoint(5), arrayOf3dPoints.getPoint(4));
        ArrayOf3dPoints arrayOf3dPoints2 = new ArrayOf3dPoints(2);
        graphics2D.setColor(this.m_GridColor);
        int n = this.m_AxisValues.getPositionCount();
        for (int i = 0; i < n; ++i) {
            IAxisValues.Position position = this.m_AxisValues.getPosition(i);
            double d = position.location * 100.0;
            Point3d point3d = line3d.position(d);
            Point3d point3d2 = line3d2.position(d);
            arrayOf3dPoints2.setPoint(0, point3d.x, point3d.y, point3d.z);
            arrayOf3dPoints2.setPoint(1, point3d2.x, point3d2.y, point3d2.z);
            ArrayOf3dPoints arrayOf3dPoints3 = renderContext.project(arrayOf3dPoints2);
            graphics2D.drawLine((int)arrayOf3dPoints3.x[0], (int)arrayOf3dPoints3.y[0], (int)arrayOf3dPoints3.x[1], (int)arrayOf3dPoints3.y[1]);
        }
        ArrayList<Label> arrayList = new ArrayList<Label>();
        this.buildLabels(renderContext, arrayOf3dPoints, arrayList);
        for (Label label : arrayList) {
            label.draw(graphics2D);
        }
    }

    @Override
    public Rectangle2D getBoundingBox(RenderContext renderContext, ArrayOf3dPoints arrayOf3dPoints) {
        ArrayList<Label> arrayList = new ArrayList<Label>();
        this.buildLabels(renderContext, arrayOf3dPoints, arrayList);
        FontRenderContext fontRenderContext = renderContext.getFontRenderContext();
        Rectangle2D rectangle2D = null;
        Iterator iterator = arrayList.iterator();
        if (iterator.hasNext()) {
            rectangle2D = ((Label)iterator.next()).getBoundingBox(fontRenderContext);
            while (iterator.hasNext()) {
                Rectangle2D.union(rectangle2D, ((Label)iterator.next()).getBoundingBox(fontRenderContext), rectangle2D);
            }
        }
        return rectangle2D;
    }
}

