/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn.chart;

import com.elixirtech.limn.chart.IAxisValues;
import java.util.Arrays;

public class StringAxisValues
implements IAxisValues {
    private String[] m_Keys;
    private boolean m_ShowLabels;
    private boolean m_ShowAxis = true;

    public StringAxisValues(Object[] objectArray, boolean bl, boolean bl2) {
        this.m_Keys = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_Keys[i] = String.valueOf(objectArray[i]);
        }
        if (bl) {
            Arrays.sort(this.m_Keys);
        }
        this.m_ShowLabels = bl2;
    }

    public StringAxisValues(String[] stringArray, boolean bl, boolean bl2) {
        this.m_Keys = stringArray;
        if (bl) {
            Arrays.sort(this.m_Keys);
        }
        this.m_ShowLabels = bl2;
    }

    @Override
    public int getPositionCount() {
        return this.m_Keys.length;
    }

    @Override
    public IAxisValues.Position getPosition(int n) {
        IAxisValues.Position position = new IAxisValues.Position();
        position.label = this.m_Keys[n];
        position.location = this.getLocation(n);
        return position;
    }

    @Override
    public double getLocation(Object object) {
        for (int i = 0; i < this.m_Keys.length; ++i) {
            if (!object.equals(this.m_Keys[i])) continue;
            return this.getLocation(i);
        }
        return 0.0;
    }

    @Override
    public boolean isShowTickLabels() {
        return this.m_ShowLabels;
    }

    @Override
    public boolean isShowAxis() {
        return this.m_ShowAxis;
    }

    @Override
    public double getStepSize() {
        if (this.m_Keys.length == 0) {
            return 0.5;
        }
        return 1.0 / (double)this.m_Keys.length;
    }

    private double getLocation(int n) {
        return ((double)n + 1.0) / ((double)this.m_Keys.length + 1.0);
    }
}

