/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map;

import com.elixirtech.data2.DataType;
import com.elixirtech.map.util.Range;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FillData {
    private final DataType m_ValueType;
    private final List<Item> m_Items = new ArrayList<Item>();
    private Range m_ValueRange;

    public FillData(DataType dataType) {
        this.m_ValueType = dataType;
    }

    public void add(Object object, Object object2) {
        this.m_Items.add(new Item(object, object2));
    }

    public void calcRange(boolean bl) {
        if (!this.m_Items.isEmpty()) {
            double d = Double.MAX_VALUE;
            double d2 = Double.MIN_VALUE;
            if (this.m_ValueType.isNumeric()) {
                for (Item item : this.m_Items) {
                    double d3 = ((Number)item.value).doubleValue();
                    d = Math.min(d, d3);
                    d2 = Math.max(d2, d3);
                }
                this.m_ValueRange = new Range(d, d2, bl);
            }
        }
    }

    public Set<Object> getKeySet() {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Item item : this.m_Items) {
            hashSet.add(item.key);
        }
        return hashSet;
    }

    public Set<Object> getValueSet() {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Item item : this.m_Items) {
            hashSet.add(item.value);
        }
        return hashSet;
    }

    public Map<Object, Color> getKeyColorMap() {
        LinkedHashMap<Object, Color> linkedHashMap = new LinkedHashMap<Object, Color>();
        for (Item item : this.m_Items) {
            linkedHashMap.put(item.key, item.color);
        }
        return linkedHashMap;
    }

    public Map<Object, Color> getValueColorMap() {
        LinkedHashMap<Object, Color> linkedHashMap = new LinkedHashMap<Object, Color>();
        for (Item item : this.m_Items) {
            linkedHashMap.put(item.value, item.color);
        }
        return linkedHashMap;
    }

    public DataType getValueType() {
        return this.m_ValueType;
    }

    public Range getValueRange() {
        return this.m_ValueRange;
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.m_Items);
    }

    public static class Item {
        public Object key;
        public Object value;
        public Color color;

        public Item() {
        }

        public Item(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }
    }
}

