/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.coloring;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.map.coloring.ArrayColoringAlgorithm;
import com.elixirtech.map.coloring.Gradient2ColoringAlgorithm;
import com.elixirtech.map.coloring.Gradient3ColoringAlgorithm;
import com.elixirtech.map.coloring.IColoringAlgorithm;
import com.elixirtech.map.coloring.ImageColoringAlgorithm;
import com.elixirtech.map.coloring.LookupColoringAlgorithm;
import java.util.HashMap;
import java.util.Map;

public class ColoringAlgorithmFactory {
    private static final Map<String, Class<? extends IColoringAlgorithm>> MAP = new HashMap<String, Class<? extends IColoringAlgorithm>>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ColoringAlgorithmFactory.class);

    public static IColoringAlgorithm build(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(40);
        if (n <= 0) {
            m_Log.warn((Object)("Invalid algorithm syntax: " + string));
            return null;
        }
        String string2 = string.substring(0, n);
        Class<? extends IColoringAlgorithm> clazz = MAP.get(string2);
        if (clazz == null) {
            m_Log.warn((Object)("Unknown algorithm: " + string2));
            return null;
        }
        String string3 = string.substring(n + 1);
        if (string3.endsWith(")")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        try {
            IColoringAlgorithm iColoringAlgorithm = clazz.newInstance();
            iColoringAlgorithm.setConfig(string3);
            return iColoringAlgorithm;
        }
        catch (Exception exception) {
            m_Log.warn((Object)("Error instantiating algorithm: " + exception), (Throwable)exception);
            return null;
        }
    }

    public static void register(String string, Class<? extends IColoringAlgorithm> clazz) {
        MAP.put(string, clazz);
    }

    static {
        ColoringAlgorithmFactory.register("array", ArrayColoringAlgorithm.class);
        ColoringAlgorithmFactory.register("gradient2", Gradient2ColoringAlgorithm.class);
        ColoringAlgorithmFactory.register("gradient3", Gradient3ColoringAlgorithm.class);
        ColoringAlgorithmFactory.register("image", ImageColoringAlgorithm.class);
        ColoringAlgorithmFactory.register("lookup", LookupColoringAlgorithm.class);
    }
}

