/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.ds;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.map.IShapes;
import com.elixirtech.map.ds.DSShape;
import com.elixirtech.map.ds.DSShapes;
import java.io.IOException;

public class DSShapeLoader {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DSShapeLoader.class);

    public IShapes loadShapes(String string) throws IOException {
        DSShapes dSShapes = new DSShapes();
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        try {
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
            DataTable dataTable = DataTable.build(iDataSource);
            DataSchema dataSchema = dataTable.getSchema();
            if (dataSchema.getColumnCount() > 0) {
                int n = dataSchema.getColumnIndex("POI_ID");
                int n2 = dataSchema.getColumnIndex("POI_NAME");
                int n3 = dataSchema.getColumnIndex("POI_X");
                int n4 = dataSchema.getColumnIndex("POI_Y");
                if (n < 0) {
                    throw new IOException("Missing 'POI_ID' column");
                }
                if (n2 < 0) {
                    throw new IOException("Missing 'POI_NAME' column");
                }
                if (n3 < 0) {
                    throw new IOException("Missing 'POI_X' column");
                }
                if (n4 < 0) {
                    throw new IOException("Missing 'POI_Y' column");
                }
                if (!dataSchema.getColumnType(n).isNumeric()) {
                    throw new IOException("POI_ID is not a numeric type");
                }
                if (!dataSchema.getColumnType(n3).isNumeric()) {
                    throw new IOException("POI_X is not a numeric type");
                }
                if (!dataSchema.getColumnType(n4).isNumeric()) {
                    throw new IOException("POI_Y is not a numeric type");
                }
                DataRecord[] dataRecordArray = dataTable.getRecords();
                for (int i = 0; i < dataRecordArray.length; ++i) {
                    try {
                        Object[] objectArray = dataRecordArray[i].getData();
                        long l = ((Number)dataSchema.narrow(DataType.LONG, objectArray[n])).longValue();
                        String string2 = (String)dataSchema.narrow(DataType.STRING, objectArray[n2]);
                        double d = ((Number)dataSchema.narrow(DataType.DOUBLE, objectArray[n3])).doubleValue();
                        double d2 = ((Number)dataSchema.narrow(DataType.DOUBLE, objectArray[n4])).doubleValue();
                        DSShape dSShape = new DSShape(l, string2, d, d2);
                        dSShapes.add(dSShape);
                        continue;
                    }
                    catch (Throwable throwable) {
                        m_Log.warn((Object)("Can't read shape value: " + throwable));
                    }
                }
                dSShapes.setRecords(dataTable);
            }
        }
        catch (Exception exception) {
            m_Log.warn((Object)("Can't read datasource: " + string));
        }
        return dSShapes;
    }
}

